/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology;

import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceModelListener;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.MenuItemSeparator;
import com.netscape.management.client.MenuItemText;
import com.netscape.management.client.ResourceModel;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.legacy.LegacyServer;
import com.netscape.management.client.legacy.plugin.LegacyAdminGroupNode;
import com.netscape.management.client.legacy.plugin.LegacyServerLocNode;
import com.netscape.management.client.legacy.plugin.LegacyServerNode;
import com.netscape.management.client.topology.DomainNode;
import com.netscape.management.client.topology.HostNode;
import com.netscape.management.client.topology.NewDomainDialog;
import com.netscape.management.client.topology.ServerNode;
import com.netscape.management.client.topology.TopTopologyNode;
import com.netscape.management.client.topology.TopologyResourcePage;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.text.MessageFormat;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class TopologyModel
extends ResourceModel
implements IMenuInfo {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.client.topology.topology");
    static String MENU_NEW_DOMAIN = "newDomain";
    static String MENU_REMOVE_DOMAIN = "removeDomain";
    static String MENU_ADD_SERVER = "addServer";
    static String MENU_REMOVE_SERVER = "removeServer";
    static String MENU_REFRESH = "refresh";
    private boolean canEditTopology = true;
    ConsoleInfo _consoleInfo;
    IResourceObject[] _selection;

    public TopologyModel(ConsoleInfo consoleInfo, boolean bl) {
        this._consoleInfo = consoleInfo;
        this.canEditTopology = bl;
        this._selection = null;
        this.setRoot((Object)new TopTopologyNode());
    }

    void updateStatusBar(IResourceObject iResourceObject) {
    }

    public void serverStateChanged(ServerNode serverNode) {
        if (this._selection != null && this._selection[0] == serverNode) {
            this.updateStatusBar((IResourceObject)serverNode);
            this.nodeChanged((ResourceObject)serverNode);
        }
    }

    public void addIResourceModelListener(IResourceModelListener iResourceModelListener) {
        super.addIResourceModelListener(iResourceModelListener);
    }

    public void removeIResourceModelListener(IResourceModelListener iResourceModelListener) {
        super.removeIResourceModelListener(iResourceModelListener);
    }

    public String[] getMenuCategoryIDs() {
        return new String[]{"FILE", "VIEW"};
    }

    public IMenuItem[] getMenuItems(String string) {
        IMenuItem[] iMenuItemArray = null;
        if (string.equals("FILE")) {
            if (this.canEditTopology) {
                iMenuItemArray = new IMenuItem[]{new MenuItemText(MENU_NEW_DOMAIN, _resource.getString("menu", "newDomain"), "TODO: description"), new MenuItemText(MENU_REMOVE_DOMAIN, _resource.getString("menu", "RemoveDomain"), "TODO: description"), new MenuItemSeparator(), new MenuItemText(MENU_ADD_SERVER, _resource.getString("menu", "AddOldServer"), "TODO: description"), new MenuItemText(MENU_REMOVE_SERVER, _resource.getString("menu", "RemoveOldServer"), "TODO: description", false), new MenuItemSeparator()};
            }
        } else if (string.equals("VIEW")) {
            MenuItemText menuItemText = new MenuItemText(MENU_REFRESH, _resource.getString("menu", "refresh"), "TODO: description");
            menuItemText.setAccelerator(KeyStroke.getKeyStroke(82, 2));
            iMenuItemArray = new IMenuItem[]{new MenuItemSeparator(), menuItemText};
        }
        return iMenuItemArray;
    }

    public void actionObjectSelected(IPage iPage, IResourceObject[] iResourceObjectArray, IResourceObject[] iResourceObjectArray2) {
        super.actionObjectSelected(iPage, iResourceObjectArray, iResourceObjectArray2);
        this._selection = iResourceObjectArray;
        if (this._selection != null) {
            if (this._selection[0] instanceof LegacyAdminGroupNode || this._selection[0] instanceof LegacyServerNode) {
                this.fireEnableMenuItem(iPage, MENU_REMOVE_SERVER);
            } else {
                this.fireDisableMenuItem(iPage, MENU_REMOVE_SERVER);
            }
            if (iResourceObjectArray[0] instanceof DomainNode && iResourceObjectArray.length == 1) {
                DomainNode domainNode = (DomainNode)this._selection[0];
                this.fireEnableMenuItem(iPage, MENU_REMOVE_DOMAIN);
            } else {
                this.fireDisableMenuItem(iPage, MENU_REMOVE_DOMAIN);
            }
            this.updateStatusBar(iResourceObjectArray[0]);
            if (this._selection.length == 1) {
                this.updateStatusBar(iResourceObjectArray[0]);
            } else {
                this.fireChangeStatusItemState(null, "StatusItemText", "");
            }
        } else {
            this.fireDisableMenuItem(iPage, MENU_REMOVE_DOMAIN);
        }
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (iMenuItem.getID().equals(MENU_NEW_DOMAIN)) {
            NewDomainDialog newDomainDialog = new NewDomainDialog(null, this._consoleInfo);
            newDomainDialog.show();
            this.refreshTree(iPage);
        } else if (iMenuItem.getID().equals(MENU_REMOVE_DOMAIN)) {
            if (this._selection[0] instanceof DomainNode) {
                this.removeDomain(iPage, (DomainNode)this._selection[0]);
                this.refreshTree(iPage);
            }
        } else if (iMenuItem.getID().equals(MENU_ADD_SERVER)) {
            LegacyServer legacyServer = new LegacyServer(this._consoleInfo);
            if (legacyServer.registerInDir() == -1) {
                Debug.println("Server not registered in DS");
            } else {
                Debug.println("Registered in DS");
            }
            this.refreshTree(iPage);
        } else if (iMenuItem.getID().equals(MENU_REMOVE_SERVER)) {
            boolean bl = false;
            if (this._selection == null) {
                Debug.println("No pre-4.0 server selected for removal.\n");
                return;
            }
            int n = this._selection.length;
            if (n == 0) {
                return;
            }
            if (n > 1) {
                Debug.println(iMenuItem + " not supported for multiple objects.");
                return;
            }
            int n2 = 0;
            while (n2 < n) {
                ResourceObject resourceObject;
                ResourceObject resourceObject2;
                LegacyServerLocNode legacyServerLocNode;
                if (this._selection[n2] instanceof LegacyAdminGroupNode && ((LegacyAdminGroupNode)(legacyServerLocNode = (LegacyAdminGroupNode)this._selection[n2])).deleteLDAPentry(2) == 0) {
                    bl = true;
                    resourceObject2 = ((LegacyAdminGroupNode)legacyServerLocNode).pruneParents(((HostNode)((Object)((DefaultMutableTreeNode)((Object)legacyServerLocNode)).getParent())).getDN());
                    if (resourceObject2 instanceof HostNode) {
                        Debug.println("Going to delete Host Node\n");
                        try {
                            this._consoleInfo.getLDAPConnection().delete(((HostNode)resourceObject2).getDN());
                        }
                        catch (LDAPException lDAPException) {
                            Debug.println("Error deleting Host Node.\n");
                        }
                    }
                    resourceObject = (ResourceObject)resourceObject2.getParent();
                    resourceObject.remove((MutableTreeNode)resourceObject2);
                }
                if (this._selection[n2] instanceof LegacyServerNode && ((LegacyServerNode)(legacyServerLocNode = (LegacyServerNode)this._selection[n2])).deleteLDAPentry() == 0) {
                    bl = true;
                    resourceObject2 = ((LegacyServerNode)legacyServerLocNode).pruneParents(((HostNode)((Object)((DefaultMutableTreeNode)((Object)legacyServerLocNode)).getParent().getParent())).getDN());
                    if (resourceObject2 instanceof HostNode) {
                        Debug.println("Going to delete Host Node\n");
                        try {
                            this._consoleInfo.getLDAPConnection().delete(((HostNode)resourceObject2).getDN());
                        }
                        catch (LDAPException lDAPException) {
                            Debug.println("Error deleting Host Node.\n");
                        }
                    }
                    resourceObject = (ResourceObject)resourceObject2.getParent();
                    resourceObject.remove((MutableTreeNode)resourceObject2);
                }
                ++n2;
            }
            if (bl) {
                this.refreshTree(iPage);
            }
        }
        if (iMenuItem.getID().equals(MENU_REFRESH)) {
            this.refreshTree(iPage);
            ((TopologyResourcePage)iPage).refresh();
        }
    }

    public void refreshTree(IPage iPage) {
        ResourceObject resourceObject = (ResourceObject)this.getRoot();
        if (resourceObject instanceof TopTopologyNode) {
            TopTopologyNode topTopologyNode = (TopTopologyNode)resourceObject;
            topTopologyNode.reload();
        }
        this.fireTreeStructureChanged(resourceObject);
        this.expandFirstNode(iPage);
    }

    private void expandFirstNode(IPage iPage) {
        ResourceObject resourceObject;
        ResourceObject resourceObject2 = (ResourceObject)this.getRoot();
        if (!resourceObject2.isLeaf() && (resourceObject = (ResourceObject)this.getChild(resourceObject2, 0)) instanceof DomainNode) {
            this.fireExpandTreeNode(iPage, resourceObject);
        }
    }

    private void removeDomain(IPage iPage, DomainNode domainNode) {
        String string;
        JFrame jFrame = iPage.getFramework().getJFrame();
        LDAPConnection lDAPConnection = this._consoleInfo.getLDAPConnection();
        if (this.hasHosts(lDAPConnection, domainNode.getDN())) {
            String string2 = _resource.getString("RemoveDomain", "cannotMessage");
            String string3 = MessageFormat.format(string2, domainNode.getName());
            String string4 = _resource.getString("RemoveDomain", "cannotTitle");
            JOptionPane.showMessageDialog(jFrame, string3, string4, 0);
            return;
        }
        String string5 = _resource.getString("RemoveDomain", "message");
        String string6 = MessageFormat.format(string5, domainNode.getName());
        int n = JOptionPane.showConfirmDialog(jFrame, string6, string = _resource.getString("RemoveDomain", "title"), 0, 3);
        if (n == 0) {
            try {
                this.deleteTree(lDAPConnection, domainNode.getDN());
            }
            catch (LDAPException lDAPException) {
                string5 = _resource.getString("RemoveDomain", "errorMessage");
                string6 = MessageFormat.format(string5, domainNode.getName());
                string = _resource.getString("RemoveDomain", "errorTitle");
                JOptionPane.showMessageDialog(jFrame, string6, string, 0);
            }
        }
    }

    void deleteTree(LDAPConnection lDAPConnection, String string) throws LDAPException {
        Debug.println("deleteTree() " + string);
        LDAPSearchResults lDAPSearchResults = null;
        String[] stringArray = new String[]{"numsubordinates"};
        lDAPSearchResults = lDAPConnection.search(string, 1, "(objectClass=*)", stringArray, false);
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = (LDAPEntry)lDAPSearchResults.nextElement();
            this.deleteTree(lDAPConnection, lDAPEntry.getDN());
        }
        Debug.println("Deleting entry " + string);
        lDAPConnection.delete(string);
    }

    boolean hasHosts(LDAPConnection lDAPConnection, String string) {
        LDAPSearchResults lDAPSearchResults = null;
        String[] stringArray = new String[]{"numsubordinates"};
        try {
            lDAPSearchResults = lDAPConnection.search(string, 1, "(objectClass=nsHost)", stringArray, false);
            return lDAPSearchResults.hasMoreElements();
        }
        catch (LDAPException lDAPException) {
            return true;
        }
    }
}

