/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.customview;

import com.netscape.management.client.IMenuInfo;
import com.netscape.management.client.IMenuItem;
import com.netscape.management.client.IPage;
import com.netscape.management.client.IResourceObject;
import com.netscape.management.client.ResourceObject;
import com.netscape.management.client.topology.INodeInfo;
import com.netscape.management.client.topology.NodeData;
import com.netscape.management.client.topology.NodeDataPanel;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.topology.customview.CustomView;
import java.awt.Component;
import java.awt.Image;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;

class ViewObject
extends ResourceObject
implements IMenuInfo,
INodeInfo {
    CustomView _view;
    IResourceObject _peerResource;
    NodeDataPanel _nodeDataPanel;
    NodeData _description;
    ImageIcon _largeIcon;
    private static String _descriptionText = TopologyInitializer._resource.getString("ServerObject", "description");

    public ViewObject(CustomView customView) {
        this._view = customView;
        this.initialize();
    }

    void initialize() {
        this._peerResource = this._view.getResourceRef();
        if (this._peerResource != null) {
            if (this._view.getParentView() == null) {
                this.setName(this._peerResource.getName());
                this.setIcon(this._peerResource.getIcon());
            } else {
                this.setName(this._view.getDisplayName());
                this.setIcon(this._view.getDisplayIcon());
            }
        } else {
            this.setName(this._view.getDisplayName());
            this.setIcon(this._view.getDisplayIcon());
            if (this._view.getDescription() != null) {
                this._description = new NodeData("id", _descriptionText, this._view.getDescription());
            }
        }
        if (this.getName() == null) {
            this.setName(this._view.getID());
        }
    }

    public Component getCustomPanel() {
        if (this._peerResource != null) {
            return this._peerResource.getCustomPanel();
        }
        if (this._nodeDataPanel == null) {
            this._nodeDataPanel = new NodeDataPanel(this.getIcon(), this.getName(), this, false, false);
        }
        return this._nodeDataPanel;
    }

    public Icon getLargeIcon() {
        Icon icon = super.getLargeIcon();
        if (icon == null) {
            ImageIcon imageIcon = (ImageIcon)this.getIcon();
            Image image = imageIcon.getImage().getScaledInstance(32, 32, 4);
            icon = new ImageIcon(image);
            this.setLargeIcon(icon);
        }
        return icon;
    }

    public void unselect(IPage iPage) {
        if (this._peerResource != null) {
            this._peerResource.unselect(iPage);
        } else {
            super.unselect(iPage);
        }
    }

    public void select(IPage iPage) {
        if (this._peerResource != null) {
            this._peerResource.select(iPage);
        } else {
            super.select(iPage);
        }
    }

    public boolean run(IPage iPage, IResourceObject[] iResourceObjectArray) {
        if (this._peerResource != null) {
            return this._peerResource.run(iPage, iResourceObjectArray);
        }
        return super.run(iPage, iResourceObjectArray);
    }

    public boolean canRunSelection(IResourceObject[] iResourceObjectArray) {
        if (this._peerResource != null) {
            return this._peerResource.canRunSelection(iResourceObjectArray);
        }
        return super.canRunSelection(iResourceObjectArray);
    }

    public String[] getMenuCategoryIDs() {
        if (this._peerResource != null && this._peerResource instanceof IMenuInfo) {
            return ((IMenuInfo)this._peerResource).getMenuCategoryIDs();
        }
        return null;
    }

    public IMenuItem[] getMenuItems(String string) {
        if (this._peerResource != null && this._peerResource instanceof IMenuInfo) {
            return ((IMenuInfo)this._peerResource).getMenuItems(string);
        }
        return null;
    }

    public void actionMenuSelected(IPage iPage, IMenuItem iMenuItem) {
        if (this._peerResource != null && this._peerResource instanceof IMenuInfo) {
            ((IMenuInfo)this._peerResource).actionMenuSelected(iPage, iMenuItem);
        }
    }

    public int getNodeDataCount() {
        return this._view.getDescription() != null ? 1 : 0;
    }

    public NodeData getNodeData(int n) {
        return this._description;
    }

    public void actionNodeDataChanged(NodeData nodeData) {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

