/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.topology.customview;

import com.netscape.management.client.ace.ACIManager;
import com.netscape.management.client.components.GenericDialog;
import com.netscape.management.client.components.Table;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.topology.ICustomView;
import com.netscape.management.client.topology.TopologyInitializer;
import com.netscape.management.client.topology.customview.CustomView;
import com.netscape.management.client.topology.customview.EditDialog;
import com.netscape.management.client.topology.customview.ViewInfo;
import com.netscape.management.client.topology.customview.VisibilityDialog;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.JButtonFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;

public class ViewSelectorDialog
extends GenericDialog {
    JFrame frame;
    Table table;
    DefaultTableModel tableModel;
    JButton newButton;
    JButton editButton;
    JButton deleteButton;
    JButton aclButton;
    Vector viewInfoVector;
    TreeModel defaultTreeModel;
    LDAPConnection ldc;
    String privateViewDN;
    String publicViewDN;
    ConsoleInfo consoleInfo;
    EditDialog editDialog = null;
    static String VIEW_PREFIX = "view";

    static String i18n(String string) {
        return TopologyInitializer._resource.getString("customview", string);
    }

    public ViewSelectorDialog(JFrame jFrame, Vector vector, TreeModel treeModel, LDAPConnection lDAPConnection, String string, String string2, ConsoleInfo consoleInfo) {
        super(jFrame, "", 12, 0);
        this.setTitle(ViewSelectorDialog.i18n("title"));
        this.newButton = JButtonFactory.create(ViewSelectorDialog.i18n("new"), new NewActionListener(), "NEW");
        this.newButton.setToolTipText(ViewSelectorDialog.i18n("new_tt"));
        this.editButton = JButtonFactory.create(ViewSelectorDialog.i18n("edit"), new EditActionListener(), "EDIT");
        this.editButton.setToolTipText(ViewSelectorDialog.i18n("edit_tt"));
        this.deleteButton = JButtonFactory.create(ViewSelectorDialog.i18n("delete"), new DeleteActionListener(), "DELETE");
        this.deleteButton.setToolTipText(ViewSelectorDialog.i18n("delete_tt"));
        this.aclButton = JButtonFactory.create(ViewSelectorDialog.i18n("access"), new AclActionListener(), "ACCESS");
        this.aclButton.setToolTipText(ViewSelectorDialog.i18n("access_tt"));
        this.frame = jFrame;
        this.consoleInfo = consoleInfo;
        this.defaultTreeModel = treeModel;
        this.ldc = lDAPConnection;
        this.privateViewDN = string;
        this.publicViewDN = string2;
        this.viewInfoVector = vector;
        this.getContentPane().add(this.createDialogPanel());
    }

    private JPanel createDialogPanel() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tableModel = new DefaultTableModel(){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.tableModel.addColumn(ViewSelectorDialog.i18n("columnName"));
        this.tableModel.addColumn(ViewSelectorDialog.i18n("columnVisibility"));
        this.table = new Table((TableModel)this.tableModel, true);
        this.table.setToolTipText(ViewSelectorDialog.i18n("table_tt"));
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ViewSelectorDialog.this.enableButtons();
            }
        });
        Enumeration enumeration = this.viewInfoVector.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (ViewInfo)enumeration.nextElement();
            object = ((ViewInfo)object2).getClassInstance();
            if (!(object instanceof CustomView) || ((CustomView)object).isSystemView()) continue;
            this.tableModel.addRow(new Object[]{object2, this.getVisibilityString(((ViewInfo)object2).isPublic())});
        }
        this.enableButtons();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        object2 = new JScrollPane(this.table);
        gridBagLayout.setConstraints((Component)object2, gridBagConstraints);
        jPanel.add((Component)object2);
        object = this.createViewButtonPanel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        jPanel.add((Component)object);
        jPanel.setPreferredSize(new Dimension(400, 200));
        return jPanel;
    }

    private String getVisibilityString(boolean bl) {
        return bl ? ViewSelectorDialog.i18n("public") : ViewSelectorDialog.i18n("private");
    }

    private void enableButtons() {
        boolean bl = this.tableModel.getRowCount() > 0;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        if (bl && listSelectionModel.isSelectionEmpty()) {
            listSelectionModel.setSelectionInterval(0, 0);
        }
        this.editButton.setEnabled(bl);
        this.deleteButton.setEnabled(bl);
        int n = this.table.getSelectedRow();
        if (n == -1) {
            bl = false;
        } else {
            ViewInfo viewInfo = (ViewInfo)this.tableModel.getValueAt(n, 0);
            bl = viewInfo.isPublic();
        }
        this.aclButton.setEnabled(bl);
    }

    protected Component createViewButtonPanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 9, 6, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.newButton, gridBagConstraints);
        jPanel.add(this.newButton);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        gridBagLayout.setConstraints(this.editButton, gridBagConstraints);
        jPanel.add(this.editButton);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.deleteButton, gridBagConstraints);
        jPanel.add(this.deleteButton);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.aclButton, gridBagConstraints);
        jPanel.add(this.aclButton);
        return jPanel;
    }

    private void deleteView(ViewInfo viewInfo) {
        try {
            String string = this.getViewDN(viewInfo);
            this.ldc.delete(string);
        }
        catch (LDAPException lDAPException) {
            Debug.println("LDAPException: return code:" + lDAPException.getLDAPResultCode());
        }
    }

    private void renameView(ViewInfo viewInfo, String string) {
        try {
            String string2 = this.getViewDN(viewInfo);
            LDAPAttribute lDAPAttribute = new LDAPAttribute("nsDisplayName", string);
            LDAPModification lDAPModification = new LDAPModification(2, lDAPAttribute);
            this.ldc.modify(string2, lDAPModification);
        }
        catch (LDAPException lDAPException) {
            Debug.println("LDAPException: return code:" + lDAPException.getLDAPResultCode());
        }
    }

    private boolean addView(ViewInfo viewInfo) {
        try {
            String string = this.getViewDN(viewInfo);
            LDAPAttribute lDAPAttribute = new LDAPAttribute("cn", viewInfo.getID());
            LDAPAttribute lDAPAttribute2 = new LDAPAttribute("objectclass", "nsCustomView");
            LDAPAttribute lDAPAttribute3 = new LDAPAttribute("objectclass", "nsTopologyCustomView");
            LDAPAttribute lDAPAttribute4 = new LDAPAttribute("nsClassName", viewInfo.getClassName());
            LDAPAttribute lDAPAttribute5 = new LDAPAttribute("nsDisplayName", viewInfo.getDisplayName());
            LDAPAttribute lDAPAttribute6 = new LDAPAttribute("nsViewConfiguration", "<none>");
            LDAPAttributeSet lDAPAttributeSet = new LDAPAttributeSet();
            lDAPAttributeSet.add(lDAPAttribute);
            lDAPAttributeSet.add(lDAPAttribute2);
            lDAPAttributeSet.add(lDAPAttribute3);
            lDAPAttributeSet.add(lDAPAttribute4);
            lDAPAttributeSet.add(lDAPAttribute5);
            lDAPAttributeSet.add(lDAPAttribute6);
            LDAPEntry lDAPEntry = new LDAPEntry(string, lDAPAttributeSet);
            this.ldc.add(lDAPEntry);
            viewInfo.setLdapEntry(lDAPEntry);
        }
        catch (LDAPException lDAPException) {
            int n = lDAPException.getLDAPResultCode();
            Debug.println("LDAPException: return code:" + n);
            if (n == 50) {
                JOptionPane.showMessageDialog(this.frame, ViewSelectorDialog.i18n("InsufficientAccessMsg"), ViewSelectorDialog.i18n("ViewCreateErrorTitle"), 0);
            }
            return false;
        }
        return true;
    }

    private String getUniqueID(boolean bl) {
        String string = bl ? this.publicViewDN : this.privateViewDN;
        int n = 1;
        while (true) {
            String string2 = "cn=" + VIEW_PREFIX + Integer.toString(n) + "," + string;
            try {
                this.ldc.read(string2);
                ++n;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) {
                    return Integer.toString(n);
                }
                return null;
            }
        }
    }

    private boolean isViewNameUsed(String string) {
        boolean bl = false;
        Enumeration enumeration = this.viewInfoVector.elements();
        while (enumeration.hasMoreElements()) {
            ViewInfo viewInfo = (ViewInfo)enumeration.nextElement();
            if (!viewInfo.getDisplayName().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private String getViewDN(ViewInfo viewInfo) {
        String string = viewInfo.isPublic() ? this.publicViewDN : this.privateViewDN;
        return "cn=" + viewInfo.getID() + "," + string;
    }

    private void showEditDialog(ViewInfo viewInfo) {
        String string = viewInfo.getDisplayName();
        ICustomView iCustomView = viewInfo.getClassInstance();
        String string2 = this.getViewDN(viewInfo);
        iCustomView.initialize(this.ldc, string2);
        TreeModel treeModel = iCustomView.getTreeModel();
        this.editDialog = new EditDialog(this.frame, this.defaultTreeModel, treeModel, string);
        this.editDialog.setNameFieldFocused();
        this.editDialog.show();
        if (!this.editDialog.isCancel()) {
            String string3 = this.editDialog.getViewName();
            iCustomView.setTreeModel(treeModel);
            if (!string3.equals(string)) {
                this.renameView(viewInfo, string3);
                viewInfo.setDisplayName(string3);
            }
        }
    }

    protected void helpInvoked() {
        Help help = new Help(TopologyInitializer._resource);
        help.contextHelp("customview", "ViewSelectorDialogHelp");
    }

    class DeleteActionListener
    implements ActionListener {
        DeleteActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ViewSelectorDialog.this.table.getSelectedRow();
            if (n < 0) {
                return;
            }
            int n2 = JOptionPane.showConfirmDialog(ViewSelectorDialog.this, ViewSelectorDialog.i18n("removeConfirm"), ViewSelectorDialog.i18n("removeTitle"), 0, 3);
            if (n2 == 0) {
                ViewInfo viewInfo = (ViewInfo)ViewSelectorDialog.this.viewInfoVector.elementAt(n);
                ViewSelectorDialog.this.deleteView(viewInfo);
                ViewSelectorDialog.this.viewInfoVector.removeElementAt(n);
                ViewSelectorDialog.this.tableModel.removeRow(n);
                if (n >= ViewSelectorDialog.this.tableModel.getRowCount()) {
                    --n;
                }
                if (ViewSelectorDialog.this.tableModel.getRowCount() > 0) {
                    ViewSelectorDialog.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
                ViewSelectorDialog.this.enableButtons();
            }
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ViewSelectorDialog.this.table.getSelectedRow();
            ViewInfo viewInfo = (ViewInfo)ViewSelectorDialog.this.tableModel.getValueAt(n, 0);
            ViewSelectorDialog.this.showEditDialog(viewInfo);
            if (!ViewSelectorDialog.this.editDialog.isCancel()) {
                ViewSelectorDialog.this.viewInfoVector.removeElementAt(n);
                ViewSelectorDialog.this.viewInfoVector.insertElementAt(viewInfo, n);
                ViewSelectorDialog.this.tableModel.removeRow(n);
                ViewSelectorDialog.this.tableModel.insertRow(n, new Object[]{viewInfo, ViewSelectorDialog.this.getVisibilityString(viewInfo.isPublic())});
                ViewSelectorDialog.this.table.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    class NewActionListener
    implements ActionListener {
        NewActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            VisibilityDialog visibilityDialog = new VisibilityDialog(ViewSelectorDialog.this.frame);
            visibilityDialog.show();
            if (visibilityDialog.isCancel()) {
                return;
            }
            boolean bl = visibilityDialog.isPublic();
            String string = ViewSelectorDialog.i18n("newView");
            String string2 = ViewSelectorDialog.this.getUniqueID(bl);
            if (string2 != null) {
                ViewInfo viewInfo = new ViewInfo(VIEW_PREFIX + string2, string + " " + string2, "com.netscape.management.client.topology.customview.CustomView");
                viewInfo.setPublic(bl);
                if (ViewSelectorDialog.this.addView(viewInfo)) {
                    ViewSelectorDialog.this.showEditDialog(viewInfo);
                    if (!ViewSelectorDialog.this.editDialog.isCancel()) {
                        ViewSelectorDialog.this.viewInfoVector.addElement(viewInfo);
                        ViewSelectorDialog.this.tableModel.addRow(new Object[]{viewInfo, ViewSelectorDialog.this.getVisibilityString(viewInfo.isPublic())});
                        int n = ViewSelectorDialog.this.table.getRowCount() - 1;
                        ViewSelectorDialog.this.table.getSelectionModel().setSelectionInterval(n, n);
                        ViewSelectorDialog.this.enableButtons();
                    } else {
                        ViewSelectorDialog.this.deleteView(viewInfo);
                    }
                }
            } else {
                Debug.println("Could not create unique view ID");
            }
        }
    }

    class AclActionListener
    implements ActionListener {
        AclActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ViewSelectorDialog.this.table.getSelectedRow();
            if (n != -1) {
                ViewInfo viewInfo = (ViewInfo)ViewSelectorDialog.this.tableModel.getValueAt(n, 0);
                String string = ViewSelectorDialog.this.getViewDN(viewInfo);
                ACIManager aCIManager = new ACIManager(ViewSelectorDialog.this.frame, viewInfo.getDisplayName(), string);
                aCIManager.show();
            }
        }
    }
}

