/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.client.util;

import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.comm.HttpChannel;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.util.AdmTaskArg;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AdmTask
implements CommClient {
    protected String _username;
    protected String _password;
    protected URL _adminURL;
    protected int _error;
    protected boolean _finished = false;
    protected HttpManager _httpManager = new HttpManager();
    protected String _argumentString = null;
    protected Hashtable _arguments = new Hashtable();
    protected Hashtable _response = new Hashtable();
    protected int _timeout;
    protected Exception _exception;
    protected StringBuffer _responseString;
    private static ResourceSet i18n = new ResourceSet("com.netscape.management.client.util.default");

    public AdmTask(URL uRL, String string, String string2) {
        this._arguments = new Hashtable();
        this._username = string;
        this._password = string2;
        this._adminURL = uRL;
    }

    public AdmTask(String string, String string2, int n, String string3, String string4, Vector vector, String string5, String string6) {
        this._username = string5;
        this._password = string6;
        try {
            this._adminURL = new URL(string, string2, n, string3 + "/" + string4 + "?");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AdmTaskArg admTaskArg = (AdmTaskArg)enumeration.nextElement();
            if (admTaskArg.val() == null) {
                this._arguments.put(admTaskArg.name(), "");
                continue;
            }
            this._arguments.put(admTaskArg.name(), admTaskArg.val());
        }
    }

    private static String i18n(String string) {
        return i18n.getString("admtask", string);
    }

    public void setUsername(String string) {
        this._username = string;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public void setResponseTimeout(int n) {
        this._timeout = n;
    }

    public String username(Object object, CommRecord commRecord) {
        return this._username;
    }

    public String password(Object object, CommRecord commRecord) {
        return this._password;
    }

    public void setArguments(Hashtable hashtable) {
        this._arguments = hashtable;
    }

    public void setArguments(String string) {
        this._argumentString = string;
    }

    public Hashtable getArguments() {
        return this._arguments;
    }

    public int addArgument(AdmTaskArg admTaskArg) {
        Object v = this._arguments.get(admTaskArg.name());
        if (v != null) {
            return -1;
        }
        if (admTaskArg.val() == null) {
            this._arguments.put(admTaskArg.name(), "");
        } else {
            this._arguments.put(admTaskArg.name(), admTaskArg.val());
        }
        return 0;
    }

    public int modArgument(AdmTaskArg admTaskArg) {
        Object v = this._arguments.get(admTaskArg.name());
        if (v == null) {
            return -1;
        }
        if (admTaskArg.val() == null) {
            this._arguments.put(admTaskArg.name(), "");
        } else {
            this._arguments.put(admTaskArg.name(), admTaskArg.val());
        }
        return 0;
    }

    public int delArgument(AdmTaskArg admTaskArg) {
        Object v = this._arguments.get(admTaskArg.name());
        if (v != null) {
            this._arguments.remove(admTaskArg.name());
            return 0;
        }
        return -1;
    }

    public int exec() {
        this._responseString = new StringBuffer();
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            if (this._timeout != 0) {
                this._httpManager.setResponseTimeout(this._timeout * 1000);
            }
            if (this._argumentString != null) {
                byteArrayInputStream = new ByteArrayInputStream(this._argumentString.getBytes());
            } else if (!this._arguments.isEmpty()) {
                byteArrayInputStream = HttpChannel.encode(this._arguments);
            }
            if (byteArrayInputStream == null) {
                this._httpManager.post(this._adminURL, (CommClient)this, null, null, 0, 2);
            } else {
                this._httpManager.post(this._adminURL, (CommClient)this, null, (InputStream)byteArrayInputStream, ((InputStream)byteArrayInputStream).available(), 2);
            }
            this.waitForFinish();
            return 0;
        }
        catch (Exception exception) {
            Debug.println("" + exception);
            this._exception = exception;
            this._error = -1;
            return -1;
        }
    }

    public int exec(HttpManager httpManager) {
        this._httpManager = httpManager;
        return this.exec();
    }

    public void trace() {
        Debug.setTrace(true);
    }

    public synchronized void waitForFinish() {
        while (!this._finished) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void finish() {
        this._finished = true;
        this.notifyAll();
    }

    public void replyHandler(InputStream inputStream, CommRecord commRecord) {
        this._error = 0;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF8"));
            while ((string = bufferedReader.readLine()) != null) {
                this.parse(string);
                this._responseString.append(string);
                this._responseString.append("\n");
            }
        }
        catch (Exception exception) {
            this._exception = exception;
            this._error = -1;
            Debug.println("AdmTask.replyHandler: " + exception);
        }
        this.finish();
    }

    public void errorHandler(Exception exception, CommRecord commRecord) {
        this._exception = exception;
        this._error = -1;
        this.finish();
    }

    public Exception getException() {
        return this._exception;
    }

    public void parse(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            if (string2.equalsIgnoreCase("NMC_Status")) {
                this._error = Integer.parseInt(string3);
            } else {
                this._response.put(string2, string3);
            }
        }
    }

    public int getStatus() {
        return this._error;
    }

    public Object getResult(String string) {
        Object object = this._response.get(string);
        if (object == null) {
            object = AdmTask.i18n("nomessage");
        }
        return object;
    }

    public Hashtable getResult() {
        return this._response;
    }

    public StringBuffer getResultString() {
        return this._responseString;
    }

    protected void setStatus(int n) {
    }

    protected void addResponseArgument(AdmTaskArg admTaskArg) {
        this._response.put(admTaskArg.name(), admTaskArg.val());
    }
}

