/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss;

import java.security.Provider;

public final class JSSProvider
extends Provider {
    private static int JSS_MAJOR_VERSION = 4;
    private static int JSS_MINOR_VERSION = 2;
    private static int JSS_PATCH_VERSION = 5;
    private static double JSS_VERSION = (double)JSS_MAJOR_VERSION + (double)(JSS_MINOR_VERSION * 100 + JSS_PATCH_VERSION) / 10000.0;

    public JSSProvider() {
        super("Mozilla-JSS", JSS_VERSION, "Provides Signature, Message Digesting, and RNG");
        this.put("Signature.SHA1withDSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$DSA");
        this.put("Alg.Alias.Signature.DSA", "SHA1withDSA");
        this.put("Alg.Alias.Signature.DSS", "SHA1withDSA");
        this.put("Alg.Alias.Signature.SHA/DSA", "SHA1withDSA");
        this.put("Alg.Alias.Signature.SHA-1/DSA", "SHA1withDSA");
        this.put("Alg.Alias.Signature.SHA1/DSA", "SHA1withDSA");
        this.put("Alg.Alias.Signature.DSAWithSHA1", "SHA1withDSA");
        this.put("Alg.Alias.Signature.SHAwithDSA", "SHA1withDSA");
        this.put("Signature.MD5/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$MD5RSA");
        this.put("Alg.Alias.Signature.MD5withRSA", "MD5/RSA");
        this.put("Signature.MD2/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$MD2RSA");
        this.put("Signature.SHA-1/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA1RSA");
        this.put("Alg.Alias.Signature.SHA1/RSA", "SHA-1/RSA");
        this.put("Alg.Alias.Signature.SHA1withRSA", "SHA-1/RSA");
        this.put("Signature.SHA-256/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA256RSA");
        this.put("Alg.Alias.Signature.SHA256/RSA", "SHA-256/RSA");
        this.put("Alg.Alias.Signature.SHA256withRSA", "SHA-256/RSA");
        this.put("Signature.SHA-384/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA384RSA");
        this.put("Alg.Alias.Signature.SHA384/RSA", "SHA-384/RSA");
        this.put("Alg.Alias.Signature.SHA384withRSA", "SHA-384/RSA");
        this.put("Signature.SHA-512/RSA", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA512RSA");
        this.put("Alg.Alias.Signature.SHA512/RSA", "SHA-512/RSA");
        this.put("Alg.Alias.Signature.SHA512withRSA", "SHA-512/RSA");
        this.put("Signature.SHA1withEC", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA1EC");
        this.put("Alg.Alias.Signature.EC", "SHA1withEC");
        this.put("Alg.Alias.Signature.ECC", "SHA1withEC");
        this.put("Alg.Alias.Signature.ECDSA", "SHA1withEC");
        this.put("Alg.Alias.Signature.SHA/EC", "SHA1withEC");
        this.put("Alg.Alias.Signature.SHA1/EC", "SHA1withEC");
        this.put("Alg.Alias.Signature.SHA-1/EC", "SHA1withEC");
        this.put("Alg.Alias.Signature.SHA/ECDSA", "SHA1withEC");
        this.put("Alg.Alias.Signature.SHA1/ECDSA", "SHA1withEC");
        this.put("Signature.SHA256withEC", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA256EC");
        this.put("Alg.Alias.Signature.SHA256/EC", "SHA256withEC");
        this.put("Alg.Alias.Signature.SHA-256/EC", "SHA256withEC");
        this.put("Signature.SHA384withEC", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA384EC");
        this.put("Alg.Alias.Signature.SHA384/EC", "SHA384withEC");
        this.put("Alg.Alias.Signature.SHA-384/EC", "SHA384withEC");
        this.put("Signature.SHA512withEC", "org.mozilla.jss.provider.java.security.JSSSignatureSpi$SHA512EC");
        this.put("Alg.Alias.Signature.SHA512/EC", "SHA512withEC");
        this.put("Alg.Alias.Signature.SHA-512/EC", "SHA512withEC");
        this.put("MessageDigest.SHA-1", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$SHA1");
        this.put("MessageDigest.MD2", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$MD2");
        this.put("MessageDigest.MD5", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$MD5");
        this.put("MessageDigest.SHA-256", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$SHA256");
        this.put("MessageDigest.SHA-384", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$SHA384");
        this.put("MessageDigest.SHA-512", "org.mozilla.jss.provider.java.security.JSSMessageDigestSpi$SHA512");
        this.put("Alg.Alias.MessageDigest.SHA1", "SHA-1");
        this.put("Alg.Alias.MessageDigest.SHA", "SHA-1");
        this.put("Alg.Alias.MessageDigest.SHA256", "SHA-256");
        this.put("Alg.Alias.MessageDigest.SHA384", "SHA-384");
        this.put("Alg.Alias.MessageDigest.SHA512", "SHA-512");
        this.put("SecureRandom.pkcs11prng", "org.mozilla.jss.provider.java.security.JSSSecureRandomSpi");
        this.put("KeyPairGenerator.RSA", "org.mozilla.jss.provider.java.security.JSSKeyPairGeneratorSpi$RSA");
        this.put("KeyPairGenerator.DSA", "org.mozilla.jss.provider.java.security.JSSKeyPairGeneratorSpi$DSA");
        this.put("KeyPairGenerator.EC", "org.mozilla.jss.provider.java.security.JSSKeyPairGeneratorSpi$EC");
        this.put("KeyFactory.RSA", "org.mozilla.jss.provider.java.security.KeyFactorySpi1_2");
        this.put("KeyFactory.DSA", "org.mozilla.jss.provider.java.security.KeyFactorySpi1_2");
        this.put("KeyFactory.EC", "org.mozilla.jss.provider.java.security.KeyFactorySpi1_2");
        this.put("AlgorithmParameters.IvAlgorithmParameters", "org.mozilla.jss.provider.java.security.IvAlgorithmParameters");
        this.put("AlgorithmParameters.RC2AlgorithmParameters", "org.mozilla.jss.provider.java.security.RC2AlgorithmParameters");
        this.put("Cipher.DES", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$DES");
        this.put("Cipher.DESede", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$DESede");
        this.put("Alg.Alias.Cipher.DES3", "DESede");
        this.put("Cipher.AES", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$AES");
        this.put("Cipher.RC4", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$RC4");
        this.put("Cipher.RSA", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$RSA");
        this.put("Cipher.RC2", "org.mozilla.jss.provider.javax.crypto.JSSCipherSpi$RC2");
        this.put("KeyGenerator.DES", "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi$DES");
        this.put("KeyGenerator.DESede", "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi$DESede");
        this.put("Alg.Alias.KeyGenerator.DES3", "DESede");
        this.put("KeyGenerator.AES", "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi$AES");
        this.put("KeyGenerator.RC4", "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi$RC4");
        this.put("KeyGenerator.RC2", "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi$RC2");
        this.put("KeyGenerator.HmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi$HmacSHA1");
        this.put("KeyGenerator.PBAHmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSKeyGeneratorSpi$PBAHmacSHA1");
        this.put("SecretKeyFactory.DES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$DES");
        this.put("SecretKeyFactory.DESede", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$DESede");
        this.put("Alg.Alias.SecretKeyFactory.DES3", "DESede");
        this.put("SecretKeyFactory.AES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$AES");
        this.put("SecretKeyFactory.RC4", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$RC4");
        this.put("SecretKeyFactory.RC2", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$RC2");
        this.put("SecretKeyFactory.HmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$HmacSHA1");
        this.put("SecretKeyFactory.PBAHmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBAHmacSHA1");
        this.put("SecretKeyFactory.PBEWithMD5AndDES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_MD5_DES_CBC");
        this.put("SecretKeyFactory.PBEWithSHA1AndDES", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_SHA1_DES_CBC");
        this.put("SecretKeyFactory.PBEWithSHA1AndDESede", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_SHA1_DES3_CBC");
        this.put("Alg.Alias.SecretKeyFactory.PBEWithSHA1AndDES3", "PBEWithSHA1AndDESede");
        this.put("SecretKeyFactory.PBEWithSHA1And128RC4", "org.mozilla.jss.provider.javax.crypto.JSSSecretKeyFactorySpi$PBE_SHA1_RC4_128");
        this.put("Mac.HmacSHA1", "org.mozilla.jss.provider.javax.crypto.JSSMacSpi$HmacSHA1");
        this.put("Alg.Alias.Mac.Hmac-SHA1", "HmacSHA1");
    }

    public String toString() {
        String string = JSS_MAJOR_VERSION + "." + JSS_MINOR_VERSION;
        if (JSS_PATCH_VERSION != 0) {
            string = string + "." + JSS_PATCH_VERSION;
        }
        return "Mozilla-JSS version " + string;
    }
}

