/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.SecretDecoderRing;

import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.SecretDecoderRing.Encoding;
import org.mozilla.jss.SecretDecoderRing.KeyManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.crypto.Cipher;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.TokenException;

public class Encryptor {
    private CryptoToken token;
    private byte[] keyID;
    private SecretKey key;
    private EncryptionAlgorithm alg;
    private KeyManager keyManager;
    public static final EncryptionAlgorithm DEFAULT_ENCRYPTION_ALG = EncryptionAlgorithm.DES3_CBC;
    static final String PROVIDER = "Mozilla-JSS";
    static final String RNG_ALG = "pkcs11prng";

    public Encryptor(CryptoToken cryptoToken, byte[] byArray, EncryptionAlgorithm encryptionAlgorithm) throws TokenException, InvalidKeyException {
        this.token = cryptoToken;
        this.keyID = byArray;
        this.alg = encryptionAlgorithm;
        this.keyManager = new KeyManager(cryptoToken);
        this.key = this.keyManager.lookupKey(encryptionAlgorithm, byArray);
        if (this.key == null) {
            throw new InvalidKeyException("Key not found");
        }
    }

    public byte[] encrypt(byte[] byArray) throws CryptoManager.NotInitializedException, GeneralSecurityException, InvalidBERException {
        CryptoManager cryptoManager = CryptoManager.getInstance();
        CryptoToken cryptoToken = cryptoManager.getThreadToken();
        try {
            cryptoManager.setThreadToken(this.token);
            byte[] byArray2 = new byte[this.alg.getIVLength()];
            SecureRandom secureRandom = SecureRandom.getInstance(RNG_ALG, PROVIDER);
            secureRandom.nextBytes(byArray2);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance(this.alg.toString(), PROVIDER);
            cipher.init(1, (Key)this.key, ivParameterSpec);
            byte[] byArray3 = Cipher.pad(byArray, this.alg.getBlockSize());
            byte[] byArray4 = cipher.doFinal(byArray3);
            Encoding encoding = new Encoding(this.keyID, byArray2, this.alg.toOID(), byArray4);
            byte[] byArray5 = ASN1Util.encode(encoding);
            return byArray5;
        }
        catch (IllegalStateException illegalStateException) {
            throw new GeneralSecurityException(illegalStateException.toString());
        }
        finally {
            cryptoManager.setThreadToken(cryptoToken);
        }
    }
}

