/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.crypto;

import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import org.mozilla.jss.crypto.Algorithm;

public class KeyPairAlgorithm
extends Algorithm {
    private static Hashtable nameMap = new Hashtable();
    protected Algorithm algFamily;
    public static final Algorithm RSAFamily = new Algorithm(4, "RSA");
    public static final Algorithm DSAFamily = new Algorithm(7, "DSA");
    public static final Algorithm ECFamily = new Algorithm(44, "EC");
    public static final KeyPairAlgorithm RSA = new KeyPairAlgorithm(5, "RSA", RSAFamily);
    public static final KeyPairAlgorithm DSA = new KeyPairAlgorithm(6, "DSA", DSAFamily);
    public static final KeyPairAlgorithm EC = new KeyPairAlgorithm(46, "EC", ECFamily);

    protected KeyPairAlgorithm(int n, String string, Algorithm algorithm) {
        super(n, string);
        this.algFamily = algorithm;
        nameMap.put(string, this);
    }

    public Algorithm getAlgFamily() {
        return this.algFamily;
    }

    public static KeyPairAlgorithm fromString(String string) throws NoSuchAlgorithmException {
        KeyPairAlgorithm keyPairAlgorithm = (KeyPairAlgorithm)nameMap.get(string);
        if (keyPairAlgorithm == null) {
            throw new NoSuchAlgorithmException();
        }
        return keyPairAlgorithm;
    }
}

