/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs11.PK11Module;
import org.mozilla.jss.pkcs11.PK11Token;
import org.mozilla.jss.util.Debug;
import org.mozilla.jss.util.IncorrectPasswordException;
import org.mozilla.jss.util.Password;

public class SelfTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Throwable {
        CryptoToken cryptoToken;
        CryptoManager cryptoManager;
        Password password = null;
        Password password2 = null;
        char[] cArray = new char[]{'f', 'o', 'o', 'b', 'a', 'r'};
        char[] cArray2 = new char[]{'n', 'e', 't', 's', 'c', 'a', 'p', 'e'};
        if (stringArray.length != 1) {
            System.err.println("Usage: java ...SelfTest <dbdir>");
            return;
        }
        CryptoManager.InitializationValues initializationValues = new CryptoManager.InitializationValues(stringArray[0]);
        CryptoManager.initialize(initializationValues);
        try {
            cryptoManager = CryptoManager.getInstance();
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            System.out.println("CryptoManager not initialized");
            return;
        }
        Debug.setLevel(10);
        try {
            cryptoToken = cryptoManager.getTokenByName("asdffda");
            System.out.println("ERROR: found a nonexistent token");
        }
        catch (NoSuchTokenException noSuchTokenException) {
            System.out.println("Good, could not find non-existent token");
        }
        try {
            Enumeration enumeration = cryptoManager.getModules();
            System.out.println("Modules:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((PK11Module)enumeration.nextElement()).getName());
            }
            enumeration = cryptoManager.getAllTokens();
            System.out.println("All Tokens:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            enumeration = cryptoManager.getExternalTokens();
            System.out.println("External Tokens:");
            while (enumeration.hasMoreElements()) {
                System.out.println("\t" + ((CryptoToken)enumeration.nextElement()).getName());
            }
            cryptoToken = cryptoManager.getTokenByName("Internal Key Storage Token");
            System.out.println("Good, found internal DB token");
            if (((Object)cryptoToken).equals(cryptoManager.getInternalKeyStorageToken())) {
                System.out.println("Good, it really is the key storage token");
            } else {
                System.out.println("ERROR: it's not the same as the key storage token!");
            }
            if (((PK11Token)cryptoToken).isInternalKeyStorageToken()) {
                System.out.println("Good, " + cryptoToken.getName() + " knows " + "what it is");
            } else {
                System.out.println("ERROR: " + cryptoToken.getName() + " doesn't know" + " it is key storage token");
            }
            CryptoToken cryptoToken2 = cryptoManager.getInternalCryptoToken();
            if (((PK11Token)cryptoToken2).isInternalCryptoToken()) {
                System.out.println("Good, " + cryptoToken.getName() + " knows it is the internal token");
            } else {
                System.out.println("ERROR: " + cryptoToken.getName() + " doesn't know what that it is the internal token");
            }
            if (!cryptoToken.isLoggedIn()) {
                System.out.println("Good, isLoggedIn correctly says we're not logged in");
            } else {
                System.out.println("ERROR: isLoggedIn incorrectly says we're logged in");
            }
            System.out.println("Good, successfully opened token \"" + cryptoToken.getName() + "\"");
            password = new Password((char[])cArray.clone());
            password2 = new Password(new char[]{'\u0000'});
            cryptoToken.initPassword(password2, password);
            password.clear();
            password2.clear();
            System.out.println("Good, initialized PIN");
            cryptoToken.logout();
            try {
                password = new Password((char[])cArray2.clone());
                cryptoToken.login(password);
                System.out.println("ERROR: Successfully logged in with wrong PIN");
            }
            catch (IncorrectPasswordException incorrectPasswordException) {
                System.out.println("Good, unable to login with wrong PIN");
            }
            finally {
                password.clear();
            }
            password = new Password((char[])cArray.clone());
            cryptoToken.login(password);
            password.clear();
            System.out.println("Good, logged in");
            if (cryptoToken.isLoggedIn()) {
                System.out.println("Good, isLoggedIn correctly says we're logged in");
            } else {
                System.out.println("ERROR: isLoggedIn incorrectly says we're not logged in");
            }
            password = new Password((char[])cArray.clone());
            password2 = new Password((char[])cArray2.clone());
            cryptoToken.changePassword(password, password2);
            password.clear();
            password2.clear();
            System.out.println("Good, changed PIN");
            try {
                password = new Password((char[])cArray.clone());
                cryptoToken.login(password);
                System.out.println("Good, logging in with wrong PIN ok if  already logged in");
            }
            catch (IncorrectPasswordException incorrectPasswordException) {
                System.out.println("ERROR: logged in second time with wrongPIN, but we should still be logged in");
            }
            finally {
                password.clear();
            }
            try {
                cryptoToken.logout();
                System.out.println("Good, logged out successfully.");
            }
            catch (TokenException tokenException) {
                System.out.println("ERROR: failed to logout from token");
            }
            if (!cryptoToken.isLoggedIn()) {
                System.out.println("Good, isLoggedIn correctly says we're not logged in");
            } else {
                System.out.println("ERROR: isLoggedIn incorrectly says we're logged in");
            }
            try {
                cryptoToken.logout();
                System.out.println("ERROR: logged out twice in a row");
            }
            catch (TokenException tokenException) {
                System.out.println("Good, got an exception when we tried to log out twice in a row");
            }
            try {
                password = new Password((char[])cArray.clone());
                cryptoToken.login(password);
                password.clear();
                System.out.println("ERROR: logged in with wrong pw");
            }
            catch (IncorrectPasswordException incorrectPasswordException) {
                System.out.println("Good, logging in with wrong PIN gave err");
            }
            System.out.println("Test completed");
            cryptoToken = null;
        }
        catch (IncorrectPasswordException incorrectPasswordException) {
            System.out.println("Got an incorrect PIN: " + incorrectPasswordException);
        }
        catch (AlreadyInitializedException alreadyInitializedException) {
            System.out.println("ERROR: This test only works with uninitialized databases");
        }
        catch (TokenException tokenException) {
            System.out.println("Token error: " + tokenException);
        }
        catch (NoSuchTokenException noSuchTokenException) {
            System.out.println("ERROR: could not find internal DB token");
        }
        finally {
            if (password != null) {
                password.clear();
            }
            if (password2 != null) {
                password2.clear();
            }
        }
    }
}

