/*
 * Decompiled with CFR 0.152.
 */
package com.sun.iiim;

import com.sun.iiim.IIIMEvent;
import java.awt.Dimension;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class IIIMLookupEvent
extends IIIMEvent {
    private int master;
    private int choicePerWindow;
    private Dimension rowColum;
    private int direction;
    private int labelOwner;
    private int firstCandidate;
    private int lastCandidate;
    private int currentCandidate;
    private String[] candidates;
    private AttributedCharacterIterator[] candidateIterator;
    private String[] labelList;
    private AttributedCharacterIterator[] labelIterator;
    private int processType;
    private int indexPage;
    private String title;
    private AttributedCharacterIterator titleIterator;
    public static final int START = 0;
    public static final int DONE = 1;
    public static final int DRAW = 2;
    public static final int PROCESS = 3;
    public static final int SERVER_MASTER = 1;
    public static final int CLIENT_MASTER = 2;
    public static final int DRAW_HORIZONTALLY = 0;
    public static final int DRAW_VERTICALLY = 1;
    public static final int SERVER_LABEL = 0;
    public static final int CLIENT_LABEL = 1;
    public static final int PROCESS_INDEX = 0;
    public static final int PROCESS_PAGE = 1;
    public static final int NEXT_PAGE = 0;
    public static final int PREV_PAGE = 1;
    public static final int FIRST_PAGE = 2;
    public static final int LAST_PAGE = 3;

    public IIIMLookupEvent(int n, int n2, int n3, Dimension dimension, int n4, int n5) {
        super(4);
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        this.type = 0;
        this.master = n2;
        this.choicePerWindow = n3;
        this.rowColum = dimension;
        this.direction = n4;
        this.labelOwner = n5;
    }

    public IIIMLookupEvent(int n) {
        super(4);
        if (n != 1) {
            throw new IllegalArgumentException();
        }
        this.type = 1;
    }

    public IIIMLookupEvent(int n, int n2, int n3, int n4, String[] stringArray, String[] stringArray2, String string) {
        super(4);
        if (n != 2) {
            throw new IllegalArgumentException();
        }
        this.type = 2;
        this.firstCandidate = n2;
        this.lastCandidate = n3;
        this.currentCandidate = n4;
        this.candidates = stringArray;
        this.labelList = stringArray2;
        this.title = string;
    }

    public IIIMLookupEvent(int n, int n2, int n3, int n4, AttributedCharacterIterator[] attributedCharacterIteratorArray, AttributedCharacterIterator[] attributedCharacterIteratorArray2, AttributedCharacterIterator attributedCharacterIterator) {
        super(4);
        if (n != 2) {
            throw new IllegalArgumentException();
        }
        this.type = 2;
        this.firstCandidate = n2;
        this.lastCandidate = n3;
        this.currentCandidate = n4;
        this.candidateIterator = attributedCharacterIteratorArray;
        this.labelIterator = attributedCharacterIteratorArray2;
        this.titleIterator = attributedCharacterIterator;
    }

    public IIIMLookupEvent(int n, int n2, int n3) {
        super(4);
        if (n != 3) {
            throw new IllegalArgumentException();
        }
        this.type = 3;
        this.processType = n2;
        this.indexPage = n3;
    }

    public int getMaster() {
        return this.master;
    }

    public int getChoicePerWindow() {
        return this.choicePerWindow;
    }

    public Dimension getRowColum() {
        return this.rowColum;
    }

    public int getDirection() {
        return this.direction;
    }

    public int getLabelOwner() {
        return this.labelOwner;
    }

    public int getFirstCandidate() {
        return this.firstCandidate;
    }

    public int getLastCandidate() {
        return this.lastCandidate;
    }

    public int getCurrentCandidate() {
        return this.currentCandidate;
    }

    public String[] getCandidates() {
        if (this.candidates == null) {
            String[] stringArray = new String[this.candidateIterator.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = IIIMEvent.iteratorToString(this.candidateIterator[n]);
                ++n;
            }
            this.candidates = stringArray;
        }
        return this.candidates;
    }

    public AttributedCharacterIterator[] getCandidateIterator() {
        if (this.candidateIterator == null) {
            AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[this.candidates.length];
            int n = 0;
            while (n < attributedCharacterIteratorArray.length) {
                attributedCharacterIteratorArray[n] = new AttributedString(this.candidates[n]).getIterator();
                ++n;
            }
            this.candidateIterator = attributedCharacterIteratorArray;
        }
        return this.candidateIterator;
    }

    public String[] getLabelList() {
        if (this.labelList == null) {
            String[] stringArray = new String[this.labelIterator.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = IIIMEvent.iteratorToString(this.labelIterator[n]);
                ++n;
            }
            this.candidates = stringArray;
        }
        return this.labelList;
    }

    public AttributedCharacterIterator[] getLabelIterator() {
        if (this.labelIterator == null) {
            AttributedCharacterIterator[] attributedCharacterIteratorArray = new AttributedCharacterIterator[this.labelList.length];
            int n = 0;
            while (n < attributedCharacterIteratorArray.length) {
                attributedCharacterIteratorArray[n] = new AttributedString(this.labelList[n]).getIterator();
                ++n;
            }
            this.labelIterator = attributedCharacterIteratorArray;
        }
        return this.labelIterator;
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = IIIMEvent.iteratorToString(this.titleIterator);
        }
        return this.title;
    }

    public AttributedCharacterIterator getTitleIterator() {
        if (this.titleIterator == null) {
            this.titleIterator = new AttributedString(this.title).getIterator();
        }
        return this.titleIterator;
    }

    public int getProcessType() {
        return this.processType;
    }

    public int getProcessIndexPage() {
        return this.indexPage;
    }
}

