/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.im.iiimp;

import java.awt.event.KeyEvent;
import java.io.IOException;
import sun.awt.im.iiimp.IIIMPKey;
import sun.awt.im.iiimp.ProtocolData;

class KeyData
extends ProtocolData {
    KeyData(KeyEvent keyEvent) throws IOException {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        int n2 = keyEvent.getModifiers();
        long l = keyEvent.getWhen();
        this.write4(n);
        this.write4(c);
        this.write4(n2);
        this.write4((int)l);
    }

    KeyData(byte[] byArray, int n) {
        super(byArray, n);
    }

    KeyData(ProtocolData protocolData) {
        super(protocolData);
    }

    IIIMPKey[] toKey() throws IOException {
        IIIMPKey[] iIIMPKeyArray = null;
        int n = this.count / 16;
        if (n > 0) {
            iIIMPKeyArray = new IIIMPKey[n];
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.read4();
                char c = (char)this.read4();
                int n4 = this.read4();
                int n5 = this.read4();
                iIIMPKeyArray[n2] = new IIIMPKey(n3, c, n4);
                ++n2;
            }
        }
        return iIIMPKeyArray;
    }

    byte[] toByteStream() throws IOException {
        if (this.count == 0) {
            return null;
        }
        int n = ProtocolData.paddings(this.count);
        int n2 = this.count + n;
        int n3 = 4 + this.count + n;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.buf, 0, byArray, 4, this.count);
        byArray[0] = (byte)(this.count >>> 24 & 0xFF);
        byArray[1] = (byte)(this.count >>> 16 & 0xFF);
        byArray[2] = (byte)(this.count >>> 8 & 0xFF);
        byArray[3] = (byte)(this.count >>> 0 & 0xFF);
        int n4 = 4 + this.count;
        while (n4 < n3) {
            byArray[n4] = 0;
            ++n4;
        }
        this.pos = this.count;
        return byArray;
    }
}

