/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.cmdln;

import com.netscape.management.admserv.cmdln.AdmpwTask;
import com.netscape.management.admserv.cmdln.CountLogEntriesTask;
import com.netscape.management.admserv.cmdln.ViewLogEntriesTask;
import com.netscape.management.client.cmd.CommandLineParser;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.URLByteEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.Vector;

public class CommandLine {
    protected static String[] _fileArgs = null;
    protected static CommandLineParser _fileOpt = null;
    protected static CommandLineParser _opt = null;
    protected static final int TC_SHOW_HELP = 0;
    protected static final int TC_RESTART = 1;
    protected static final int TC_STOP = 2;
    protected static final int TC_GET_SYSTEM_USER = 3;
    protected static final int TC_SET_SYSTEM_USER = 4;
    protected static final int TC_GET_PORT = 5;
    protected static final int TC_SET_PORT = 6;
    protected static final int TC_GET_ADMINUSERS = 7;
    protected static final int TC_SET_ADMINUSERS = 8;
    protected static final int TC_GET_ERRORLOG = 9;
    protected static final int TC_SET_ERRORLOG = 10;
    protected static final int TC_GET_ACCESSLOG = 11;
    protected static final int TC_SET_ACCESSLOG = 12;
    protected static final int TC_GET_HOSTS = 13;
    protected static final int TC_SET_HOSTS = 14;
    protected static final int TC_GET_ADDRESSES = 15;
    protected static final int TC_SET_ADDRESSES = 16;
    protected static final int TC_GET_ONEACLDIR = 17;
    protected static final int TC_SET_ONEACLDIR = 18;
    protected static final int TC_GET_DEFAULTACCEPTLANGUAGE = 19;
    protected static final int TC_SET_DEFAULTACCEPTLANGUAGE = 20;
    protected static final int TC_GET_CLASSNAME = 21;
    protected static final int TC_SET_CLASSNAME = 22;
    protected static final int TC_COUNT_ERRORLOG_ENTRIES = 23;
    protected static final int TC_VIEW_ERRORLOG_ENTRIES = 24;
    protected static final int TC_COUNT_ACCESSLOG_ENTRIES = 25;
    protected static final int TC_VIEW_ACCESSLOG_ENTRIES = 26;
    protected static final int TC_ENABLE_ENDUSER_ACCESS = 27;
    protected static final int TC_DISABLE_ENDUSER_ACCESS = 28;
    protected static final int TC_ENABLE_DSGW_ACCESS = 29;
    protected static final int TC_DISABLE_DSGW_ACCESS = 30;
    protected static final int TC_GET_ADMIN_UID = 31;
    protected static final int TC_SET_ADMIN_UID = 32;
    protected static final int TC_SET_ADMIN_PWD = 33;
    protected static final int TC_GET_DSCONFIG = 34;
    protected static final int TC_SET_DSCONFIG = 35;
    protected static final int TC_GET_CACHE_LIFETIME = 36;
    protected static final int TC_SET_CACHE_LIFETIME = 37;
    protected static final int TC_GET_SERVER_ADDRESS = 38;
    protected static final int TC_SET_SERVER_ADDRESS = 39;
    protected static final int TC_GET_UGDSCONFIG = 40;
    protected static final int TC_SET_UGDSCONFIG = 41;
    protected static final String[] _admconfigHelpLookup = new String[]{"[help-main]", "[help-restart]", "[help-stop]", "[help-getsystemuser]", "[help-setsystemuser]", "[help-getport]", "[help-setport]", "[help-getadminusers]", "[help-setadminusers]", "[help-geterrorlog]", "[help-seterrorlog]", "[help-getaccesslog]", "[help-setaccesslog]", "[help-gethosts]", "[help-sethosts]", "[help-getaddresses]", "[help-setaddresses]", "[help-getoneacldir]", "[help-setoneacldir]", "[help-getdefaultacceptlanguage]", "[help-setdefaultacceptlanguage]", "[help-getclassname]", "[help-setclassname]", "[help-counterrorlogentries]", "[help-viewerrorlogentries]", "[help-countaccesslogentries]", "[help-viewaccesslogentries]", "[help-enableenduseraccess]", "[help-disableenduseraccess]", "[help-enabledsgwaccess]", "[help-disabledsgwaccess]", "[help-getadminuid]", "[help-setadminuid]", "[help-setadminpwd]", "[help-getdsconfig]", "[help-setdsconfig]", "[help-getcachelifetime]", "[help-setcachelifetime]", "[help-getserveraddress]", "[help-setserveraddress]", "[help-getugdsconfig]", "[help-setugdsconfig]"};
    protected static final String[] _admconfigTaskLookup = new String[]{"-restart", "-stop", "-getsystemuser", "-setsystemuser", "-getport", "-setport", "-getadminusers", "-setadminusers", "-geterrorlog", "-seterrorlog", "-getaccesslog", "-setaccesslog", "-gethosts", "-sethosts", "-getaddresses", "-setaddresses", "-getoneacldir", "-setoneacldir", "-getdefaultacceptlanguage", "-setdefaultacceptlanguage", "-getclassname", "-setclassname", "-counterrorlogentries", "-viewerrorlogentries", "-countaccesslogentries", "-viewaccesslogentries", "-enableenduseraccess", "-disableenduseraccess", "-enabledsgwaccess", "-disabledsgwaccess", "-getadminuid", "-setadminuid", "-setadminpwd", "-getdsconfig", "-setdsconfig", "-getcachelifetime", "-setcachelifetime", "-getserveraddress", "-setserveraddress", "-getugdsconfig", "-setugdsconfig"};
    protected static final int OPT_ENCRYPTION = 0;
    protected static final int OPT_HELP = 1;
    protected static final int OPT_INPUT_FILE = 2;
    protected static final int OPT_QUIET_LEVEL = 3;
    protected static final int OPT_SERVER = 4;
    protected static final int OPT_USER = 5;
    protected static final int OPT_VERSION = 6;
    protected static final int OPT_CONTINUE_ON_ERROR = 7;
    protected static final int OPT_TASKS_OFFSET = 7;
    protected static final String[] _admconfigControlStrings = new String[]{"-encryption", "-help:", "-inputfile:", "-verbose:", "-server:", "-user:", "-version", "-continueonerror", "-restart", "-stop", "-getsystemuser", "-setsystemuser:", "-getport", "-setport:", "-getadminusers", "-setadminusers:", "-geterrorlog", "-seterrorlog:", "-getaccesslog", "-setaccesslog:", "-gethosts", "-sethosts:", "-getaddresses", "-setaddresses:", "-getoneacldir", "-setoneacldir:", "-getdefaultacceptlanguage", "-setdefaultacceptlanguage:", "-getclassname", "-setclassname:", "-counterrorlogentries", "-viewerrorlogentries:", "-countaccesslogentries", "-viewaccesslogentries:", "-enableenduseraccess", "-disableenduseraccess", "-enabledsgwaccess", "-disabledsgwaccess", "-getadminuid", "-setadminuid:", "-setadminpwd:", "-getdsconfig", "-setdsconfig:", "-getcachelifetime", "-setcachelifetime:", "-getserveraddress", "-setserveraddress:", "-getugdsconfig", "-setugdsconfig:"};
    protected static final String PACKAGE_DIR = "com/netscape/management/admserv/cmdln";
    protected static final String RESTART_TASK = "admin-serv/tasks/operation/Restart";
    protected static final String STOP_TASK = "admin-serv/tasks/operation/Stop";
    protected static final String READ_LOG_TASK = "admin-serv/tasks/configuration/ReadLog";
    protected static final String SERVER_SETUP_TASK = "admin-serv/tasks/configuration/ServerSetup";
    protected static final String ACCESS_SETUP_TASK = "admin-serv/tasks/configuration/AccessSetup";
    protected static final String DIRECTORY_SETUP_TASK = "admin-serv/tasks/configuration/DirectorySetup";
    protected static final String UG_DIRECTORY_SETUP_TASK = "admin-serv/tasks/configuration/UGDirectorySetup";
    protected static final String DATA_FILE = "admconfig.dat";
    protected static final String VERSION_FILE = "version.dat";
    protected String _protocol;
    protected String _server;
    protected String _admin;
    protected String _password;
    protected int _tc;
    protected String _task;
    protected String _inputFile;
    protected int _verbose;
    protected String _newValue;
    protected boolean _quitOnError;

    public static void main(String[] args) {
        CommandLine cl = new CommandLine(args);
        cl.run(_fileOpt, _fileArgs, false);
        cl.run(_opt, args, true);
        System.exit(0);
    }

    private void printRestartMessage() {
        System.out.println("\nRestart the Admin Server for the changes to take effect.");
    }

    public CommandLine(String[] args) {
        if (args.length < 1) {
            this.showHelp(_admconfigHelpLookup[0]);
            System.exit(0);
        }
        _opt = new CommandLineParser(_admconfigControlStrings, args);
        this._protocol = "http";
        this._tc = 0;
        this._verbose = 5;
        this._quitOnError = true;
        this.handleInputFile(_opt, args);
        this.parseArguments(_opt, args, true);
    }

    public void run(CommandLineParser taskOpt, String[] taskArgs, boolean taskRequired) {
        if (taskOpt == null || taskArgs == null || taskArgs.length == 0) {
            if (taskRequired) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Task not specified.");
                System.err.println("    Try admconfig -h for help on using admconfig.\n");
                System.exit(1);
            } else {
                return;
            }
        }
        int tc = 0;
        if (taskArgs != null) {
            int i = 0;
            while (i < taskArgs.length) {
                this._newValue = null;
                tc = this.getTaskCode(taskArgs[i], false);
                switch (tc) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 16: 
                    case 18: 
                    case 20: 
                    case 22: 
                    case 24: 
                    case 26: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 37: 
                    case 39: {
                        this._newValue = taskOpt.getOptionParam(_admconfigControlStrings[tc + 7]);
                        if (this._newValue != null) break;
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Invalid number of parameters specified for task.");
                        this.showHelp(_admconfigHelpLookup[tc]);
                        if (this._quitOnError) {
                            System.exit(1);
                            break;
                        }
                        return;
                    }
                    case 41: {
                        this._newValue = taskOpt.getOptionParam(_admconfigControlStrings[tc + 7]);
                        break;
                    }
                }
                if (0 != tc) {
                    this._tc = tc;
                    if (9 == this._verbose) {
                        System.out.println("\nadmconfig: about to run " + this._task);
                        if (this._newValue != null) {
                            System.out.println("admconfig:        task arg: " + this._newValue);
                        }
                    }
                    this.runTask();
                }
                ++i;
            }
        }
        if (taskRequired && 0 == this._tc) {
            System.err.println("ERROR admconfig:");
            System.err.println("    No valid task was specified.");
            System.err.println("    Try admconfig -h for help on using admconfig.\n");
            System.exit(1);
        }
    }

    public void runTask() {
        try {
            AdmTask task;
            URL taskurl = null;
            String encodedFilename = null;
            StringTokenizer tokenizer = null;
            String startToken = null;
            String stopToken = null;
            String dsHostToken = null;
            String dsPortToken = null;
            String dsBaseDNToken = null;
            String dsSSLFlagToken = null;
            String dsSSLFlagResult = null;
            String dsBindDNToken = null;
            String dsBindPwdToken = null;
            String dsURL = null;
            int logStart = 0;
            int logStop = 0;
            int dsPort = 0;
            int adminPort = 0;
            int cacheLifetime = 0;
            switch (this._tc) {
                case 1: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + RESTART_TASK + "?op=restart");
                    break;
                }
                case 2: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + STOP_TASK);
                    break;
                }
                case 3: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nssuitespotuser") + "=");
                    break;
                }
                case 4: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nssuitespotuser") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 5: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserverport") + "=");
                    break;
                }
                case 6: {
                    adminPort = 0;
                    try {
                        adminPort = Integer.parseInt(this._newValue);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Specified server port is invalid: " + this._newValue);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserverport") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 7: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminusers") + "=");
                    break;
                }
                case 8: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminusers") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 9: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nserrorlog") + "=");
                    break;
                }
                case 10: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nserrorlog") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 11: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsaccesslog") + "=");
                    break;
                }
                case 12: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsaccesslog") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 13: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccesshosts") + "=");
                    break;
                }
                case 14: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccesshosts") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 15: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccessaddresses") + "=");
                    break;
                }
                case 16: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminaccessaddresses") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 17: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminoneacldir") + "=");
                    break;
                }
                case 18: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminoneacldir") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 19: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsdefaultacceptlanguage") + "=");
                    break;
                }
                case 20: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsdefaultacceptlanguage") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 21: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsclassname") + "=");
                    break;
                }
                case 22: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsclassname") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 36: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadmincachelifetime") + "=");
                    break;
                }
                case 37: {
                    cacheLifetime = 0;
                    try {
                        cacheLifetime = Integer.parseInt(this._newValue);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Specified cache lifetime is invalid: " + this._newValue);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadmincachelifetime") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 38: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserveraddress") + "=");
                    break;
                }
                case 39: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsserveraddress") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 23: {
                    encodedFilename = this.getLog("configuration.nserrorlog");
                    if (encodedFilename == null) {
                        return;
                    }
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=count&" + "name=" + encodedFilename);
                    break;
                }
                case 24: {
                    tokenizer = new StringTokenizer(this._newValue);
                    if (tokenizer.countTokens() != 2) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + tokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    startToken = tokenizer.nextToken();
                    logStart = 0;
                    try {
                        logStart = Integer.parseInt(startToken);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to start viewing is invalid: " + startToken);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    stopToken = tokenizer.nextToken();
                    logStop = 0;
                    try {
                        logStop = Integer.parseInt(stopToken);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to stop viewing is invalid: " + stopToken);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    encodedFilename = this.getLog("configuration.nserrorlog");
                    if (encodedFilename == null) {
                        return;
                    }
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=read&" + "name=" + encodedFilename + "&start=" + startToken + "&stop=" + stopToken);
                    break;
                }
                case 25: {
                    encodedFilename = this.getLog("configuration.nsaccesslog");
                    if (encodedFilename == null) {
                        return;
                    }
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=count&" + "name=" + encodedFilename);
                    break;
                }
                case 26: {
                    tokenizer = new StringTokenizer(this._newValue);
                    if (tokenizer.countTokens() != 2) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + tokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    startToken = tokenizer.nextToken();
                    logStart = 0;
                    try {
                        logStart = Integer.parseInt(startToken);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to start viewing is invalid: " + startToken);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    stopToken = tokenizer.nextToken();
                    logStop = 0;
                    try {
                        logStop = Integer.parseInt(stopToken);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The entry number to stop viewing is invalid: " + stopToken);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    encodedFilename = this.getLog("configuration.nsaccesslog");
                    if (encodedFilename == null) {
                        return;
                    }
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + READ_LOG_TASK + "?op=read&" + "name=" + encodedFilename + "&start=" + startToken + "&stop=" + stopToken);
                    break;
                }
                case 27: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=force_set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminenableenduser") + "=");
                    break;
                }
                case 28: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=force_set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminenableenduser") + "=off");
                    break;
                }
                case 29: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=force_set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminenabledsgw") + "=");
                    break;
                }
                case 30: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=force_set&" + URLByteEncoder.encodeUTF8((String)"configuration.nsadminenabledsgw") + "=off");
                    break;
                }
                case 31: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + ACCESS_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)"admpw.uid") + "=");
                    break;
                }
                case 32: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + ACCESS_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"admpw.uid") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 33: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + ACCESS_SETUP_TASK + "?op=set&" + URLByteEncoder.encodeUTF8((String)"admpw.pw") + "=" + URLByteEncoder.encodeUTF8((String)this._newValue));
                    break;
                }
                case 34: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + DIRECTORY_SETUP_TASK);
                    break;
                }
                case 35: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + DIRECTORY_SETUP_TASK);
                    tokenizer = new StringTokenizer(this._newValue);
                    if (tokenizer.countTokens() != 3) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + tokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    dsHostToken = tokenizer.nextToken();
                    dsPortToken = tokenizer.nextToken();
                    dsPort = 0;
                    try {
                        dsPort = Integer.parseInt(dsPortToken);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The dsconfig.port parameter is invalid: " + dsPortToken);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    dsSSLFlagToken = tokenizer.nextToken();
                    if (dsSSLFlagToken.equalsIgnoreCase("true") || dsSSLFlagToken.equalsIgnoreCase("false")) break;
                    System.err.println("ERROR admconfig:");
                    System.err.println("    Cannot run " + this._task);
                    System.err.println("    The dsconfig.ssl parameter is invalid: " + dsSSLFlagToken);
                    System.err.println("");
                    if (this._quitOnError) {
                        System.exit(1);
                        break;
                    }
                    return;
                }
                case 40: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + UG_DIRECTORY_SETUP_TASK);
                    break;
                }
                case 41: {
                    taskurl = new URL(this._protocol + "://" + this._server + "/" + UG_DIRECTORY_SETUP_TASK);
                    if (this._newValue == null) break;
                    tokenizer = new StringTokenizer(this._newValue);
                    if (tokenizer.countTokens() != 6) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    Invalid number of arguments for the task: " + tokenizer.countTokens());
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    dsHostToken = tokenizer.nextToken();
                    dsPortToken = tokenizer.nextToken();
                    dsPort = 0;
                    try {
                        dsPort = Integer.parseInt(dsPortToken);
                    }
                    catch (NumberFormatException e) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The port parameter is invalid: " + dsPortToken);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        }
                        return;
                    }
                    dsBaseDNToken = tokenizer.nextToken();
                    dsBaseDNToken = dsBaseDNToken.replace('+', ' ');
                    dsSSLFlagToken = tokenizer.nextToken();
                    if (!dsSSLFlagToken.equalsIgnoreCase("true") && !dsSSLFlagToken.equalsIgnoreCase("false")) {
                        System.err.println("ERROR admconfig:");
                        System.err.println("    Cannot run " + this._task);
                        System.err.println("    The ssl parameter is invalid: " + dsSSLFlagToken);
                        System.err.println("");
                        if (this._quitOnError) {
                            System.exit(1);
                        } else {
                            return;
                        }
                    }
                    dsBindDNToken = tokenizer.nextToken();
                    dsBindDNToken = dsBindDNToken.replace('+', ' ');
                    dsBindPwdToken = tokenizer.nextToken();
                    dsBindPwdToken = dsBindPwdToken.replace('+', ' ');
                    break;
                }
                default: {
                    System.err.println("ERROR admconfig:");
                    System.err.println("    Invalid task specified = " + this._tc);
                    System.err.println("");
                    if (this._quitOnError) {
                        System.exit(1);
                        break;
                    }
                    return;
                }
            }
            switch (this._tc) {
                case 31: 
                case 32: 
                case 33: {
                    task = new AdmpwTask(taskurl, this._admin, this._password);
                    break;
                }
                case 23: 
                case 25: {
                    task = new CountLogEntriesTask(taskurl, this._admin, this._password);
                    break;
                }
                case 24: 
                case 26: {
                    task = new ViewLogEntriesTask(taskurl, this._admin, this._password);
                    break;
                }
                case 34: {
                    task = new AdmTask(taskurl, this._admin, this._password);
                    task.setArguments("op=getconfig");
                    break;
                }
                case 35: {
                    task = new AdmTask(taskurl, this._admin, this._password);
                    task.setArguments("op=setconfig&" + URLByteEncoder.encodeUTF8((String)"dsconfig.host") + "=" + URLEncoder.encode(dsHostToken) + "&" + URLByteEncoder.encodeUTF8((String)"dsconfig.port") + "=" + dsPortToken + "&" + URLByteEncoder.encodeUTF8((String)"dsconfig.ssl") + "=" + dsSSLFlagToken);
                    break;
                }
                case 40: {
                    task = new AdmTask(taskurl, this._admin, this._password);
                    task.setArguments("op=getconfig");
                    break;
                }
                case 41: {
                    task = new AdmTask(taskurl, this._admin, this._password);
                    if (this._newValue == null) {
                        task.setArguments("op=setconfig&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.inforef") + "=" + URLByteEncoder.encodeUTF8((String)"default"));
                        break;
                    }
                    dsURL = dsSSLFlagToken.equalsIgnoreCase("true") ? "ldaps://" + dsHostToken + ":" + dsPortToken + "/" + dsBaseDNToken : "ldap://" + dsHostToken + ":" + dsPortToken + "/" + dsBaseDNToken;
                    task.setArguments("op=setconfig&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.dirurl") + "=" + URLByteEncoder.encodeUTF8((String)dsURL) + "&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.binddn") + "=" + URLByteEncoder.encodeUTF8((String)dsBindDNToken) + "&" + URLByteEncoder.encodeUTF8((String)"ugdsconfig.bindpw") + "=" + URLByteEncoder.encodeUTF8((String)dsBindPwdToken));
                    break;
                }
                default: {
                    task = new AdmTask(taskurl, this._admin, this._password);
                }
            }
            int execStatus = task.exec();
            if (execStatus != 0) {
                System.err.println("Status = " + execStatus);
                System.err.println("    exec failed for " + this._task);
                System.err.println("");
                if (!this._quitOnError) {
                    return;
                }
            } else {
                int status = task.getStatus();
                if ((status != 3 || this._tc != 1 && this._tc != 2) && status != 0) {
                    System.err.println("Status = " + status);
                    System.err.println("    Task " + this._task + " failed: " + task.getResult("NMC_ErrInfo"));
                    System.err.println("");
                    if (this._quitOnError) {
                        System.exit(status);
                    } else {
                        return;
                    }
                }
                System.out.println("Task " + this._task + " succeeded with status = " + status);
                switch (this._tc) {
                    case 1: {
                        System.out.println("    Server has been restarted.");
                        System.out.println("\nWaiting 15 seconds for the server to come up before continuing.");
                        System.out.println("Press Ctrl-C to exit admconfig.");
                        Thread.sleep(15000L);
                        break;
                    }
                    case 2: {
                        System.out.println("    Server has been stopped.");
                        System.out.println("\nThe server must be started before any more tasks can be run.\n");
                        System.exit(0);
                        break;
                    }
                    case 3: {
                        System.out.println("    configuration.nssuitespotuser = " + task.getResult("configuration.nssuitespotuser"));
                        break;
                    }
                    case 5: {
                        System.out.println("    configuration.nsserverport = " + task.getResult("configuration.nsserverport"));
                        break;
                    }
                    case 7: {
                        System.out.println("    configuration.nsadminusers = " + task.getResult("configuration.nsadminusers"));
                        break;
                    }
                    case 9: {
                        System.out.println("    configuration.nserrorlog = " + task.getResult("configuration.nserrorlog"));
                        break;
                    }
                    case 11: {
                        System.out.println("    configuration.nsaccesslog = " + task.getResult("configuration.nsaccesslog"));
                        break;
                    }
                    case 13: {
                        System.out.println("    configuration.nsadminaccesshosts = " + task.getResult("configuration.nsadminaccesshosts"));
                        break;
                    }
                    case 15: {
                        System.out.println("    configuration.nsadminaccessaddresses = " + task.getResult("configuration.nsadminaccessaddresses"));
                        break;
                    }
                    case 17: {
                        System.out.println("    configuration.nsadminoneacldir = " + task.getResult("configuration.nsadminoneacldir"));
                        break;
                    }
                    case 19: {
                        System.out.println("    configuration.nsdefaultacceptlanguage = " + task.getResult("configuration.nsdefaultacceptlanguage"));
                        break;
                    }
                    case 21: {
                        System.out.println("    configuration.nsclassname = " + task.getResult("configuration.nsclassname"));
                        break;
                    }
                    case 36: {
                        System.out.println("    configuration.nsadmincachelifetime = " + task.getResult("configuration.nsadmincachelifetime"));
                        break;
                    }
                    case 38: {
                        System.out.println("    configuration.nsserveraddress = " + task.getResult("configuration.nsserveraddress"));
                        break;
                    }
                    case 23: 
                    case 25: {
                        System.out.println("    count = " + task.getResult("count"));
                        break;
                    }
                    case 24: 
                    case 26: {
                        System.out.println(task.getResult("result"));
                        break;
                    }
                    case 27: {
                        System.out.println("    End user access has been enabled.");
                        break;
                    }
                    case 28: {
                        System.out.println("    End user access has been disabled.");
                        break;
                    }
                    case 29: {
                        System.out.println("    Directory Server Gateway access has been enabled.");
                        break;
                    }
                    case 30: {
                        System.out.println("    Directory Server Gateway access has been disabled.");
                        break;
                    }
                    case 31: {
                        System.out.println("    admpw.uid = " + task.getResult("admpw.uid"));
                        break;
                    }
                    case 34: {
                        System.out.println("    dsconfig.host   = " + task.getResult("dsconfig.host"));
                        System.out.println("    dsconfig.port   = " + task.getResult("dsconfig.port"));
                        dsSSLFlagResult = (String)task.getResult("dsconfig.ssl");
                        if (dsSSLFlagResult == null || dsSSLFlagResult.equalsIgnoreCase("false")) {
                            System.out.println("    dsconfig.ssl    = false");
                            break;
                        }
                        System.out.println("    dsconfig.ssl    = true");
                        break;
                    }
                    case 40: {
                        System.out.println("    ugdsconfig.inforef      = " + task.getResult("ugdsconfig.inforef"));
                        System.out.println("    ugdsconfig.globaldirurl = " + task.getResult("ugdsconfig.globaldirurl"));
                        System.out.println("    ugdsconfig.dirurl       = " + task.getResult("ugdsconfig.dirurl"));
                        System.out.println("    ugdsconfig.binddn       = " + task.getResult("ugdsconfig.binddn"));
                        break;
                    }
                }
                switch (this._tc) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 32: 
                    case 33: 
                    case 35: 
                    case 41: {
                        this.printRestartMessage();
                    }
                }
                System.out.println("");
                return;
            }
            System.exit(execStatus);
        }
        catch (Exception e) {
            System.err.println("ERROR admconfig:");
            System.err.println("    Task " + this._task + " caused an exception.");
            System.err.println("    Exception: " + e);
            System.err.println("");
            if (this._quitOnError) {
                System.exit(1);
            }
            return;
        }
    }

    protected void parseArguments(CommandLineParser opt, String[] args, boolean argRequired) {
        this.handleHelp(opt);
        this.handleVersion(opt);
        if (opt.hasOption(_admconfigControlStrings[3])) {
            String verbose = opt.getOptionParam(_admconfigControlStrings[3]);
            if (null == verbose) {
                this._verbose = 9;
            } else {
                try {
                    this._verbose = Integer.parseInt(verbose);
                }
                catch (NumberFormatException e) {
                    System.err.println("WARNING admconfig:");
                    System.err.println("    Parameter for -verbose option is not a number: " + verbose);
                    System.err.println("    Setting verbose level to 9.");
                    this._verbose = 9;
                }
                if (this._verbose < 0 || this._verbose > 9) {
                    System.err.println("WARNING admconfig:");
                    System.err.println("    Invalid level: " + this._verbose);
                    System.err.println("    Setting verbose level to default value of 5.");
                    this._verbose = 5;
                }
            }
            if (9 == this._verbose) {
                System.out.println("admconfig:         verbose: " + this._verbose);
            }
        }
        if (opt.hasOption(_admconfigControlStrings[0])) {
            this._protocol = "https";
            if (9 == this._verbose) {
                System.out.println("admconfig:        protocol: " + this._protocol);
            }
        }
        if (opt.hasOption(_admconfigControlStrings[7])) {
            this._quitOnError = false;
            if (9 == this._verbose) {
                System.out.println("admconfig:   quit on error: " + this._quitOnError);
            }
        }
        if (opt.hasOption(_admconfigControlStrings[4])) {
            String serverInfo = opt.getOptionParam(_admconfigControlStrings[4]);
            if (null == serverInfo) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Required parameter for the -server option was not specified.");
                this.showHelp(_admconfigHelpLookup[0]);
                System.exit(1);
            } else {
                int colonIndex = serverInfo.indexOf(58);
                if (-1 == colonIndex || colonIndex + 1 == serverInfo.length()) {
                    System.err.println("ERROR admconfig:");
                    System.err.println("    Server port was not specified.");
                    System.err.println("    Try admconfig -h for help on using admconfig.\n");
                    System.exit(1);
                }
                this._server = 0 == colonIndex ? "localhost" + serverInfo : serverInfo;
            }
            if (9 == this._verbose) {
                System.out.println("admconfig:          server: " + this._server);
            }
        }
        if (argRequired && null == this._server) {
            System.err.println("ERROR admconfig:");
            System.err.println("    Server name and port number were not specified.");
            System.err.println("    Try admconfig -h for help on using admconfig.\n");
            System.exit(1);
        }
        if (opt.hasOption(_admconfigControlStrings[5])) {
            String userInfo = opt.getOptionParam(_admconfigControlStrings[5]);
            if (null == userInfo) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Required parameter for the -user option was not specified.");
                this.showHelp(_admconfigHelpLookup[0]);
                System.exit(1);
            } else {
                int colonIndex = userInfo.indexOf(58);
                this._admin = -1 == colonIndex ? userInfo : (0 == colonIndex ? System.getProperty("user.name") : userInfo.substring(0, colonIndex));
                if (-1 == colonIndex || colonIndex + 1 == userInfo.length()) {
                    this.promptForPassword();
                } else {
                    this._password = userInfo.substring(colonIndex + 1);
                }
            }
            if (9 == this._verbose) {
                System.out.println("admconfig:          userid: " + this._admin);
                System.out.println("admconfig:        password: " + this._password);
            }
        }
        if (argRequired) {
            if (null == this._admin && null == this._password) {
                this.promptForAdminInfo();
                if (9 == this._verbose) {
                    System.out.println("admconfig:          userid: " + this._admin);
                    System.out.println("admconfig:        password: " + this._password);
                }
            } else if (null == this._admin || this._admin.length() == 0) {
                this._admin = System.getProperty("user.name");
            } else if (null == this._password || this._password.length() == 0) {
                this.promptForPassword();
            }
        }
    }

    protected void handleInputFile(CommandLineParser opt, String[] args) {
        this._inputFile = null;
        if (opt.hasOption(_admconfigControlStrings[2])) {
            String inputFile = opt.getOptionParam(_admconfigControlStrings[2]);
            if (null == inputFile) {
                System.err.println("ERROR admconfig:");
                System.err.println("    No file specified for the -inputFile option. Ignoring option.");
            } else {
                this._inputFile = inputFile;
            }
        }
        if (this._inputFile != null) {
            try {
                File f = new File(this._inputFile);
                FileReader fr = new FileReader(f);
                long fsize = f.length();
                char[] data = new char[(int)fsize];
                long bytesRead = 0L;
                while (bytesRead < fsize) {
                    bytesRead += (long)fr.read(data, (int)bytesRead, (int)(fsize - bytesRead));
                }
                fr.close();
                String dataString = new String(data);
                StringTokenizer tokenizer = new StringTokenizer(dataString);
                String token = null;
                Vector<String> v = new Vector<String>();
                while (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    Debug.println((String)("TRACE CommandLine.handleInputFile: token from file: " + token));
                    v.addElement(token);
                }
                int vsize = v.size();
                _fileArgs = new String[vsize];
                v.copyInto(_fileArgs);
                _fileOpt = new CommandLineParser(_admconfigControlStrings, _fileArgs);
                this.parseArguments(_fileOpt, _fileArgs, false);
            }
            catch (IOException e) {
                System.err.println("ERROR admconfig:");
                System.err.println("    IOException: " + e);
                System.err.println("");
                System.exit(1);
            }
        }
    }

    protected void handleHelp(CommandLineParser opt) {
        if (opt.hasOption(_admconfigControlStrings[1])) {
            String helpTask = opt.getOptionParam(_admconfigControlStrings[1]);
            this._tc = null == helpTask ? 0 : this.getTaskCode("-" + helpTask, true);
            this.showHelp(_admconfigHelpLookup[this._tc]);
            System.exit(0);
        }
    }

    protected void handleVersion(CommandLineParser opt) {
        if (opt.hasOption(_admconfigControlStrings[6])) {
            this.showVersion();
            System.exit(0);
        }
    }

    protected void showHelp(String lookupString) {
        String filename = DATA_FILE;
        if (filename != null) {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                InputStream is = ClassLoader.getSystemResourceAsStream("com/netscape/management/admserv/cmdln/" + filename);
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (line.equalsIgnoreCase(lookupString)) break;
                }
                if (line == null) {
                    System.err.println("ERROR admconfig:");
                    System.err.println("    No help information available for " + lookupString);
                    System.err.println("");
                    System.exit(1);
                }
                while ((line = br.readLine()) != null) {
                    if (line.length() > 0 && line.charAt(0) == '[') break;
                    System.out.println(line);
                }
                br.close();
            }
            catch (IOException e) {
                System.err.println("ERROR admconfig:");
                System.err.println("    IOException: " + e);
                System.err.println("");
                System.exit(1);
            }
        }
    }

    protected void showVersion() {
        String filename = VERSION_FILE;
        if (filename != null) {
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                InputStream is = ClassLoader.getSystemResourceAsStream("com/netscape/management/admserv/cmdln/" + filename);
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
                br.close();
            }
            catch (IOException e) {
                System.err.println("ERROR admconfig:");
                System.err.println("    IOException: " + e);
                System.err.println("");
                System.exit(1);
            }
        }
    }

    protected void promptForPassword() {
        try {
            FileReader fr = new FileReader(FileDescriptor.in);
            BufferedReader br = new BufferedReader(fr);
            do {
                System.out.print("Password: ");
                this._password = br.readLine();
            } while (this._password.length() <= 0);
            br.close();
            return;
        }
        catch (IOException e) {
            System.err.println("ERROR admconfig:");
            System.err.println("    IOException: " + e);
            System.err.println("");
            System.exit(1);
            return;
        }
    }

    protected void promptForAdminInfo() {
        try {
            FileReader fr = new FileReader(FileDescriptor.in);
            BufferedReader br = new BufferedReader(fr);
            do {
                System.out.print("Username: ");
                this._admin = br.readLine();
            } while (this._admin.length() <= 0);
            do {
                System.out.print("Password: ");
                this._password = br.readLine();
            } while (this._password.length() <= 0);
            br.close();
            return;
        }
        catch (IOException e) {
            System.err.println("ERROR admconfig:");
            System.err.println("    IOException: " + e);
            System.err.println("");
            System.exit(1);
            return;
        }
    }

    protected int getTaskCode(String taskString, boolean alertOnMismatch) {
        int count = 0;
        int taskCode = 0;
        String lowerCaseTaskString = taskString.toLowerCase();
        int i = 0;
        while (i < _admconfigTaskLookup.length) {
            if (_admconfigTaskLookup[i].startsWith(lowerCaseTaskString)) {
                ++count;
                taskCode = i + 1;
                this._task = taskString + " (" + _admconfigTaskLookup[i] + ")";
            }
            ++i;
        }
        if (count == 0 || count > 1) {
            if (alertOnMismatch) {
                System.err.println("ERROR admconfig:");
                System.err.println("    Unknown or ambiguous task: " + taskString);
            }
            return 0;
        }
        return taskCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getLog(String log) {
        String encodedResult = null;
        try {
            URL getLogURL = new URL(this._protocol + "://" + this._server + "/" + SERVER_SETUP_TASK + "?op=get&" + URLByteEncoder.encodeUTF8((String)log) + "=");
            AdmTask getLogTask = new AdmTask(getLogURL, this._admin, this._password);
            int execStatus = getLogTask.exec();
            if (execStatus != 0) {
                System.err.println("Status = " + execStatus);
                System.err.println("    Failed to get " + log);
                System.err.println("");
                if (!this._quitOnError) return null;
                System.exit(execStatus);
            } else {
                int taskStatus = getLogTask.getStatus();
                if (taskStatus != 0) {
                    System.err.println("Status = " + taskStatus);
                    System.err.println("    Failed to get " + log + ": " + getLogTask.getResult("NMC_ErrInfo"));
                    System.err.println("");
                    if (!this._quitOnError) return null;
                    System.exit(taskStatus);
                }
            }
            String result = (String)getLogTask.getResult(log);
            if (result.startsWith("admin-serv/") && result.indexOf("..") == -1) {
                return URLByteEncoder.encodeUTF8((String)("../../../../" + result));
            }
            System.err.println("ERROR admconfig:");
            System.err.println("    Cannot run " + this._task);
            System.err.println("    Invalid log name: " + result);
            System.err.println("    Log names must start with \"admin-serv/\" and no \"..\" are allowed.\n");
            if (!this._quitOnError) return null;
            System.exit(1);
            return encodedResult;
        }
        catch (Exception e) {
            System.err.println("ERROR admconfig:");
            System.err.println("    Exception: " + e);
            System.err.println("");
            if (!this._quitOnError) return null;
            System.exit(1);
            return encodedResult;
        }
    }
}

