/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.config;

import com.netscape.management.admserv.config.GBC;
import com.netscape.management.client.util.JButtonFactory;
import com.netscape.management.client.util.ResourceSet;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonBar
extends JPanel {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.config.config");
    public static String _i18nOKButton = _resource.getString("common", "OKButton");
    public static String _i18nCancelButton = _resource.getString("common", "CancelButton");
    public static String _i18nCloseButton = _resource.getString("common", "CloseButton");
    public static String _i18nHelpButton;
    public static String _i18nSaveButton;
    public static String _i18nResetButton;
    public static String _i18nSaveToolTip;
    public static String _i18nResetToolTip;
    public static String _i18nHelpToolTip;
    public static final String cmdOK = "ok";
    public static final String cmdCancel = "cancel";
    public static final String cmdClose = "close";
    public static final String cmdHelp = "help";
    protected Vector _buttons = new Vector(5);
    private static String[] stdCommands;
    private static String[] stdLabels;
    private static String[] stdToolTips;
    private static String[] stdDialogCommands;
    private static String[] stdDialogLabels;

    public ButtonBar() {
        this(stdCommands, stdLabels, true);
    }

    public ButtonBar(boolean isDialog) {
        this(isDialog ? stdDialogCommands : stdCommands, isDialog ? stdDialogLabels : stdLabels, true);
    }

    public ButtonBar(boolean isDialog, String[] toolTips) {
        this(isDialog ? stdDialogCommands : stdCommands, isDialog ? stdDialogLabels : stdLabels, toolTips, true);
    }

    public ButtonBar(String[] commands, String[] labels, boolean isHorizontal) {
        this(commands, labels, stdToolTips, isHorizontal);
    }

    public ButtonBar(String[] commands, String[] labels, String[] toolTips, boolean isHorizontal) {
        JPanel p = new JPanel();
        GBC gbc = new GBC();
        if (commands.length != labels.length && commands.length != toolTips.length) {
            throw new IllegalArgumentException("In Constructor ButtonBar():  commands.length=" + commands.length + ",labels.length=" + labels.length + ",toolTips.length=" + toolTips.length);
        }
        this.setLayout(new GridBagLayout());
        p.setLayout(new GridBagLayout());
        int gridx = 0;
        int gridy = 0;
        int insetTop = 0;
        int insetLeft = 0;
        int insetBottom = 0;
        int insetRight = 0;
        boolean newButtonGroup = false;
        JButton[] factoryButtons = JButtonFactory.create((String[])labels);
        int i = 0;
        while (i < labels.length) {
            if (labels[i] == null) {
                newButtonGroup = true;
            } else {
                JButton button = factoryButtons[i];
                this._buttons.addElement(button);
                button.setActionCommand(commands[i]);
                JButtonFactory.initializeMnemonic((JButton)button);
                button.setToolTipText(toolTips[i]);
                insetRight = 0;
                insetBottom = 0;
                insetLeft = 0;
                insetTop = 0;
                if (isHorizontal) {
                    if (i != 0) {
                        insetLeft = newButtonGroup ? 12 : 6;
                    }
                } else if (i != 0) {
                    insetTop = newButtonGroup ? 12 : 6;
                }
                gbc.setInsets(insetTop, insetLeft, insetBottom, insetRight);
                gbc.setGrid(gridx, gridy, 1, 1);
                gbc.setSpace(1.0, 0.0, 10, 0);
                p.add((Component)button, gbc);
                if (isHorizontal) {
                    ++gridx;
                } else {
                    ++gridy;
                }
                newButtonGroup = false;
            }
            ++i;
        }
        gbc.setInsets(0, 0, 0, 0);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 13, 0);
        this.add((Component)p, gbc);
    }

    public JButton getButton(String command) {
        int i = 0;
        while (i < this._buttons.size()) {
            JButton button = (JButton)this._buttons.elementAt(i);
            if (button.getActionCommand().equals(command)) {
                return button;
            }
            ++i;
        }
        return null;
    }

    public void addActionListener(ActionListener listener) {
        int i = 0;
        while (i < this._buttons.size()) {
            JButton button = (JButton)this._buttons.elementAt(i);
            button.addActionListener(listener);
            ++i;
        }
    }

    public void removeActionListener(ActionListener listener) {
        int i = 0;
        while (i < this._buttons.size()) {
            JButton button = (JButton)this._buttons.elementAt(i);
            button.removeActionListener(listener);
            ++i;
        }
    }

    static {
        _i18nSaveButton = _resource.getString("common", "SaveButton");
        _i18nResetButton = _resource.getString("common", "ResetButton");
        _i18nHelpButton = _resource.getString("common", "HelpButton");
        _i18nSaveToolTip = _resource.getString("common", "SaveToolTip");
        _i18nResetToolTip = _resource.getString("common", "ResetToolTip");
        _i18nHelpToolTip = _resource.getString("common", "HelpToolTip");
        stdCommands = new String[]{cmdOK, cmdCancel, null, cmdHelp};
        stdLabels = new String[]{_i18nSaveButton, _i18nResetButton, null, _i18nHelpButton};
        stdToolTips = new String[]{_i18nSaveToolTip, _i18nResetToolTip, null, _i18nHelpToolTip};
        stdDialogCommands = new String[]{cmdOK, cmdCancel, null, cmdHelp};
        stdDialogLabels = new String[]{_i18nOKButton, _i18nCancelButton, null, _i18nHelpButton};
    }
}

