/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.logging;

import com.netscape.management.admserv.logging.AccessLogData;
import com.netscape.management.admserv.logging.AccessLogViewerModel;
import com.netscape.management.client.comm.AbstractCommClient;
import com.netscape.management.client.comm.CommRecord;
import com.netscape.management.client.logging.ILogViewerModel;
import com.netscape.management.client.util.Debug;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

class AccessDataCommClient
extends AbstractCommClient {
    final int STATE_HOST = 0;
    final int STATE_USERNAME = 1;
    final int STATE_DATE = 2;
    final int STATE_TIME = 3;
    final int STATE_PRE_HEADER = 4;
    final int STATE_HEADER = 5;
    final int STATE_PRE_HTTPCODE = 6;
    final int STATE_HTTPCODE = 7;
    final int STATE_DATALENGTH = 8;
    final int STATE_EXTRA = 9;
    AccessLogViewerModel model;

    public AccessDataCommClient(AccessLogViewerModel model, String username, String password) {
        super(username, password);
        this.model = model;
        Debug.println((int)6, (String)"AccessLogViewer: AccessDataCommClient.<init>");
    }

    protected AccessLogData parse(String logEntry) {
        StringBuffer buffer = new StringBuffer(logEntry);
        AccessLogData data = new AccessLogData();
        int bufferLength = buffer.length();
        int state = 0;
        int index = 0;
        while (index < bufferLength) {
            char character = buffer.charAt(index);
            switch (state) {
                case 0: {
                    if (character == '-') {
                        state = 1;
                        break;
                    }
                    if (character == ' ') break;
                    data.host.append(character);
                    break;
                }
                case 1: {
                    if (character == '[') {
                        state = 2;
                        break;
                    }
                    if (character == ' ') break;
                    data.username.append(character);
                    break;
                }
                case 2: {
                    if (character == ':') {
                        state = 3;
                        break;
                    }
                    data.date.append(character);
                    break;
                }
                case 3: {
                    if (character == ']') {
                        state = 4;
                        break;
                    }
                    data.time.append(character);
                    break;
                }
                case 4: {
                    if (character != '\"') break;
                    state = 5;
                    break;
                }
                case 5: {
                    if (character == '\"') {
                        state = 6;
                        break;
                    }
                    data.header.append(character);
                    break;
                }
                case 6: {
                    if (character != ' ') break;
                    state = 7;
                    break;
                }
                case 7: {
                    if (character == ' ') {
                        state = 8;
                        break;
                    }
                    data.httpcode.append(character);
                    break;
                }
                case 8: {
                    if (character == ' ') {
                        state = 9;
                        break;
                    }
                    data.datalength.append(character);
                    break;
                }
            }
            ++index;
        }
        return data;
    }

    public void replyHandler(InputStream replyStream, CommRecord cr) {
        BufferedReader replyBuffer = new BufferedReader(new InputStreamReader(replyStream));
        ILogViewerModel model = (ILogViewerModel)cr.getArg();
        int rowOffset = model.getRowOffset();
        int bufferLength = model.getBufferLength();
        String logEntry = null;
        int rowIndex = 0;
        while (rowIndex < bufferLength) {
            try {
                logEntry = replyBuffer.readLine();
            }
            catch (Exception e) {
                Debug.println((int)4, (String)("AccessLogViewer: replyHandler() " + e));
            }
            if (logEntry == null) break;
            AccessLogData d = this.parse(logEntry);
            model.setValueAt(Integer.toString(rowOffset + rowIndex), rowIndex, 0);
            model.setValueAt(d.host, rowIndex, 1);
            model.setValueAt(d.username, rowIndex, 2);
            model.setValueAt(d.date, rowIndex, 3);
            model.setValueAt(d.time, rowIndex, 4);
            model.setValueAt(d.header, rowIndex, 5);
            model.setValueAt(d.httpcode, rowIndex, 6);
            model.setValueAt(d.datalength, rowIndex, 7);
            ++rowIndex;
        }
        this.finish();
    }

    public synchronized void finish() {
        super.finish();
        this.model.tableDataChanged();
        Debug.println((int)9, (String)"AccessLogViewer: AccessDataCommClient.finish()");
    }
}

