/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.logging;

import com.netscape.management.admserv.AdminServer;
import com.netscape.management.admserv.logging.AccessDataCommClient;
import com.netscape.management.admserv.logging.AccessLogLengthCommClient;
import com.netscape.management.client.comm.CommClient;
import com.netscape.management.client.comm.HttpManager;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.logging.LogViewerModel;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.table.DefaultTableModel;

public class AccessLogViewerModel
extends LogViewerModel {
    ConsoleInfo _consoleInfo;
    String _url;
    String _username;
    String _password;
    int _logLength = 0;
    private boolean _isInitialized = false;
    public boolean _logLengthAvailable = false;
    public boolean _logLengthCalculating = false;
    public StringBuffer _logLengthStringBuffer = null;
    public static ResourceSet _resource = AdminServer._resource;

    public AccessLogViewerModel(ConsoleInfo consoleInfo, String url) {
        this._consoleInfo = consoleInfo;
        this._url = this._consoleInfo.getAdminURL() + url;
        this._username = this._consoleInfo.getAuthenticationDN();
        this._password = this._consoleInfo.getAuthenticationPassword();
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "lineno"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "host"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "username"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "date"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "time"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "header"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "errorcode"));
        ((DefaultTableModel)((Object)this)).addColumn(_resource.getString("log", "length"));
        this._isInitialized = true;
    }

    public void populateRows(int rowStartIndex, int numRows) {
        Debug.println((int)6, (String)("AccessLogViewer: populateRows " + rowStartIndex + " to " + (rowStartIndex + numRows)));
        try {
            URL url = new URL(this._url + "?op=read" + "&start=" + rowStartIndex + "&stop=" + (rowStartIndex + numRows) + "&" + URLEncoder.encode("name=../../../../admin-serv/logs/access"));
            HttpManager _httpManager = new HttpManager();
            AccessDataCommClient commClient = new AccessDataCommClient(this, this._username, this._password);
            _httpManager.get(url, (CommClient)commClient, (Object)this, 3);
        }
        catch (Exception e) {
            Debug.println((int)4, (String)("AccessLogViewer: populateRows() " + e));
        }
    }

    public int getLogLength() {
        if (!this._isInitialized) {
            return -1;
        }
        long _currentTimeMillis = System.currentTimeMillis();
        if (_currentTimeMillis - this._lastLogLengthCheckTime > LogViewerModel.UPDATE_INTERVAL && !this._logLengthCalculating) {
            this._lastLogLengthCheckTime = _currentTimeMillis;
            try {
                this._logLengthCalculating = true;
                this._logLengthAvailable = false;
                this._logLengthStringBuffer = new StringBuffer();
                URL url = new URL(this._url + "?op=count" + "&" + URLEncoder.encode("name=../../../../admin-serv/logs/access"));
                HttpManager _httpManager = new HttpManager();
                AccessLogLengthCommClient commClient = new AccessLogLengthCommClient(this, this._username, this._password);
                _httpManager.get(url, (CommClient)commClient, (Object)this._logLengthStringBuffer, 3);
            }
            catch (Exception e) {
                this._logLengthCalculating = false;
                Debug.println((int)4, (String)("AccessLogViewer: getLogLength(): " + e));
            }
        }
        if (this._logLengthAvailable) {
            try {
                this._logLength = Integer.parseInt(this._logLengthStringBuffer.toString());
                Debug.println((int)6, (String)("AccessLogViewer: _logLength=" + this._logLength));
            }
            catch (NumberFormatException e) {
                Debug.println((int)4, (String)("AccessLogViewer: Cannot convert log length: " + this._logLengthStringBuffer.toString()));
            }
        }
        return this._logLength;
    }
}

