/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ConfigInfoDialog;
import com.netscape.management.admserv.config.RemoteRequestException;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGIDataModel;
import com.netscape.management.admserv.panel.IRestartControl;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.client.util.URLByteEncoder;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class CGIServerSetup
extends CGIDataModel {
    private static String _taskURL = "admin-serv/tasks/Configuration/ServerSetup";
    private String _portValue = null;
    private String _addrValue = null;

    public CGIServerSetup(ConsoleInfo consoleInfo) {
        super(consoleInfo, _taskURL);
    }

    public void setAttribute(String attr, String val) throws ValidationException {
        super.setAttribute(attr, val);
    }

    public static String encodeFilterList(Vector members) {
        String regex;
        int size = members.size();
        if (size == 0) {
            regex = "";
        } else if (size == 1) {
            regex = (String)members.elementAt(0);
        } else {
            regex = "(";
            int i = 0;
            while (i < size) {
                regex = i == 0 ? regex + (String)members.elementAt(i) : regex + "|" + (String)members.elementAt(i);
                ++i;
            }
            regex = regex + ")";
        }
        Debug.println((String)("encodeFilterList=" + regex));
        return regex;
    }

    public static Vector parseFilterList(String regex) {
        Vector<String> list = new Vector<String>();
        if (regex != null && regex.length() != 0) {
            if (regex.startsWith("(") && regex.endsWith(")")) {
                String members = regex.substring(1, regex.length() - 1);
                Debug.println((String)("members=" + members));
                StringTokenizer strtok = new StringTokenizer(members, "|");
                while (strtok.hasMoreTokens()) {
                    list.addElement(strtok.nextToken());
                }
            } else {
                list.addElement(regex);
            }
        }
        return list;
    }

    public String getCGIParamsForGetOp() {
        return "op=get&configuration.nsserverport=&configuration.nsserveraddress=&configuration.nsadminaccesshosts=&configuration.nsadminaccessaddresses=&configuration.nsadminenabledsgw=&configuration.nssuitespotuser=";
    }

    public String getCGIParamsForSetOp() {
        String op = "op=force_set&";
        Enumeration e = this._data.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = (String)this._data.get(name);
            if (name.equals("configuration.nsserverport") && value.equals(this._portValue) || name.equals("configuration.nsserveraddress") && this._addrValue == null && value.length() == 0) continue;
            op = op + name + "=" + URLByteEncoder.encodeUTF8((String)value) + (e.hasMoreElements() ? "&" : "");
        }
        return op;
    }

    public void load() throws RemoteRequestException {
        super.load();
        if (this.getAttribute("configuration.nsadminenabledsgw") == null) {
            this._data.put("configuration.nsadminenabledsgw", "on");
            this._origData.put("configuration.nsadminenabledsgw", "on");
        }
        this._portValue = this.getAttribute("configuration.nsserverport");
        this._addrValue = this.getAttribute("configuration.nsserveraddress");
    }

    public void save() throws RemoteRequestException {
        super.save();
        String newPort = this.getAttribute("configuration.nsserverport");
        String newAddr = this.getAttribute("configuration.nsserveraddress");
        boolean portChanged = false;
        boolean addrChanged = false;
        Debug.println((String)("newAddr=<" + newAddr + "> prevAddr=<" + this._addrValue + ">"));
        if (this._portValue != null && !this._portValue.equals(newPort)) {
            portChanged = true;
            this._portValue = newPort;
        }
        if (this._addrValue == null || this._addrValue.length() == 0) {
            addrChanged = newAddr.length() != 0;
            this._addrValue = newAddr;
        } else {
            addrChanged = !this._addrValue.equals(newAddr);
            this._addrValue = newAddr;
        }
        if (portChanged || addrChanged) {
            ResourceSet resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
            String msg = resource.getString("adminop", "NeedRestartReconnect");
            ConfigInfoDialog.showDialog(this.getDialogParent(), msg, "");
            try {
                URL url = new URL(this._consoleInfo.getAdminURL());
                String host = addrChanged && newAddr.length() != 0 ? newAddr : url.getHost();
                String port = portChanged ? newPort : String.valueOf(url.getPort());
                String postRestartURL = url.getProtocol() + "://" + host + ":" + port + "/";
                Debug.println((String)("oldURL = " + this._consoleInfo.getAdminURL() + " postRestartURL = " + postRestartURL));
                IRestartControl restartControl = (IRestartControl)this._consoleInfo.get("RESTART_CONTROL");
                if (restartControl != null) {
                    restartControl.setPostRestartURL(postRestartURL);
                }
            }
            catch (Exception e) {
                Debug.println((String)("postRestartURL " + e));
            }
        } else {
            ResourceSet resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
            String msg = resource.getString("adminop", "NeedRestart");
            ConfigInfoDialog.showDialog(this.getDialogParent(), msg, "");
        }
    }
}

