/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.ManagerList;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SNMPManagerPanel
extends PluginConfigPanel {
    IConfigDataModel _configData;
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nDescription = _resource.getString("snmpmgr", "Description");
    static String _i18nEditDialogTitle = _resource.getString("snmpmgr", "EditDialogTitle");
    static String _i18nAddDialogTitle = _resource.getString("snmpmgr", "AddDialogTitle");
    static String _i18nManager = _resource.getString("snmpmgr", "Manager");
    static String _i18nPort = _resource.getString("snmpmgr", "Port");
    static String _i18nCommunity = _resource.getString("snmpmgr", "Community");
    static String _i18nDetailsGroupbox = _resource.getString("snmpmgr", "DetailsGroupbox");
    static String _i18nMsgEnterManager = _resource.getString("snmpmgr", "MsgEnterManager");
    static String _i18nMsgEntryExists = _resource.getString("snmpmgr", "MsgEntryExists");
    static String _i18nMsgCanNotRename = _resource.getString("snmpmgr", "MsgCanNotRename");
    Help _help;
    JLabel _lblDescription;
    ManagerList _managerList;
    Vector _managers = new Vector();

    public SNMPManagerPanel(String title, IConfigDataModel data) {
        super(title);
        this._configData = data;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makePanel(), "North");
        this._help = new Help(_resource);
    }

    public void showHelp() {
        this._help.contextHelp("SNMPManagerHelp");
    }

    public void initialize() throws ConfigPanelException {
        this.setPanelContent(this._configData);
    }

    public IConfigDataModel getDataModel() {
        return this._configData;
    }

    public void setDataModel(IConfigDataModel data) throws ValidationException {
        this._configData = data;
        if (this._configData.isLoaded()) {
            this.setPanelContent(this._configData);
        }
    }

    public void resetContent() throws ConfigPanelException {
        this.setPanelContent(this._configData);
    }

    public void applyChanges() throws ValidationException {
        this.getPanelContent(this._configData);
    }

    public void registerEditComponents(EditMonitor editMonitor) {
        this._managerList.addListDataListener(editMonitor);
    }

    public void setPanelContent(IConfigDataModel data) throws ValidationException {
        String value = data.getAttribute("snmp.managers");
        this._managers = CGISNMPSetup.stringToManagerVector(value);
        this._managerList.setManagers(this._managers);
    }

    public void getPanelContent(IConfigDataModel data) throws ValidationException {
        String value = CGISNMPSetup.managerVectorToString(this._managers);
        Debug.println((String)("managers value = <" + value + ">"));
        data.setAttribute("snmp.managers", value);
    }

    protected JComponent makePanel() {
        JPanel p = new JPanel();
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        JLabel lbl = new JLabel(_i18nDescription);
        gbc.setInsets(10, 0, 10, 0);
        gbc.setGrid(0, 0, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)lbl, gbc);
        this._managerList = new ManagerList(this._managers);
        gbc.setGrid(0, 1, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._managerList, gbc);
        return p;
    }
}

