/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ButtonBar;
import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.GBC;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.PluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.admserv.panel.AdminOperation;
import com.netscape.management.admserv.panel.CGISNMPSetup;
import com.netscape.management.admserv.panel.DialogFrame;
import com.netscape.management.admserv.panel.IAdminOperationListener;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ModalDialogUtil;
import com.netscape.management.client.util.ResourceSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SNMPStatusPanel
extends PluginConfigPanel {
    ConsoleInfo _target;
    ConsoleInfo _consoleInfo;
    Hashtable _statusTable = new Hashtable();
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    static String _i18nAgentOn = _resource.getString("status", "AgentOn");
    static String _i18nAgentOff = _resource.getString("status", "AgentOff");
    static String _i18nAgentUnknown = _resource.getString("status", "AgentUnknown");
    static String _i18nOn = _resource.getString("status", "On");
    static String _i18nOff = _resource.getString("status", "Off");
    static String _i18nUnknown = _resource.getString("status", "Unknown");
    static String _i18nMasterAgent = _resource.getString("status", "MasterAgent");
    static String _i18nStatus = _resource.getString("status", "Status");
    static String _i18nCheckStatusButton = _resource.getString("status", "CheckStatus");
    static String _i18nRestartButton = _resource.getString("status", "Restart");
    static String _i18nStopButton = _resource.getString("status", "Stop");
    static String _i18nDialogTitleStop = _resource.getString("status", "DialogStopAgent");
    static String _i18nDialogTitleRestart = _resource.getString("status", "DialogRestartAgent");
    static String _i18nDialogTitleStatus = _resource.getString("status", "DialogStatusAgent");
    static String _i18nCheckStatusToolTip = _resource.getString("status", "CheckStatusToolTip");
    static String _i18nRestartToolTip = _resource.getString("status", "RestartToolTip");
    static String _i18nStopToolTip = _resource.getString("status", "StopToolTip");
    static Help _help;
    static String _cmdStatus;
    static String _cmdRestart;
    static String _cmdStop;
    JLabel _lblStatus;
    ButtonBar _buttons;
    String _agentColumn;
    ActionListener _btnListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(_cmdStatus)) {
                SNMPStatusPanel.this.checkStatus(SNMPStatusPanel.this._target, false);
            } else if (cmd.equals(_cmdRestart)) {
                SNMPStatusPanel.this.restart(SNMPStatusPanel.this._target);
            } else if (cmd.equals(_cmdStop)) {
                SNMPStatusPanel.this.stop(SNMPStatusPanel.this._target);
            } else {
                Debug.println((String)("SNMPStatusPanel: Unknown acction command " + cmd));
            }
        }
    };

    public SNMPStatusPanel(String title, ConsoleInfo consoleInfo) {
        super(title);
        this._target = this._consoleInfo = consoleInfo;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makePanel(), "North");
        _help = new Help(_resource);
        this.updateStatus();
    }

    public void showHelp() {
        _help.contextHelp("SNMPStatusHelp");
    }

    void updateStatus() {
        this._lblStatus.setVisible(true);
        this.validate();
        String agent = (String)this._target.get("SERVER_NAME");
        String status = (String)this._statusTable.get(agent);
        String string = status = status == null ? _i18nUnknown : status;
        if (status.equals(_i18nOn)) {
            this._lblStatus.setText(_i18nAgentOn);
        } else if (status.equals(_i18nOff)) {
            this._lblStatus.setText(_i18nAgentOff);
        } else {
            this._lblStatus.setText(_i18nAgentUnknown);
        }
    }

    void updateStatus(String agent) {
        String status = (String)this._statusTable.get(agent);
        String string = status = status == null ? _i18nUnknown : status;
        if (status.equals(_i18nOn)) {
            this._lblStatus.setText(_i18nAgentOn);
        } else if (status.equals(_i18nOff)) {
            this._lblStatus.setText(_i18nAgentOff);
        } else {
            this._lblStatus.setText(_i18nAgentUnknown);
        }
    }

    public void initialize() throws ConfigPanelException {
        this.checkStatus(this._consoleInfo, true);
    }

    public IConfigDataModel getDataModel() {
        return null;
    }

    public void setDataModel(IConfigDataModel data) throws ValidationException {
        if (data != null) {
            this._target = data instanceof CGISNMPSetup ? ((CGISNMPSetup)data).getConsoleInfo() : this._consoleInfo;
            this.updateStatus();
        }
    }

    public void resetContent() throws ConfigPanelException {
    }

    public void applyChanges() throws ValidationException {
    }

    public void registerEditComponents(EditMonitor editMonitor) {
    }

    protected JComponent makePanel() {
        JPanel p = new JPanel();
        GBC gbc = new GBC();
        GridBagLayout gbl = new GridBagLayout();
        p.setLayout(gbl);
        this._lblStatus = new JLabel(_i18nAgentUnknown);
        gbc.setInsets(10, 0, 10, 0);
        gbc.setGrid(0, 0, 2, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)this._lblStatus, gbc);
        gbc.setInsets(10, 0, 10, 0);
        gbc.setGrid(0, 1, 1, 1);
        gbc.setSpace(1.0, 0.0, 17, 2);
        p.add((Component)new JLabel(), gbc);
        this._buttons = new ButtonBar(new String[]{_cmdStatus, _cmdRestart, _cmdStop}, new String[]{_i18nCheckStatusButton, _i18nRestartButton, _i18nStopButton}, new String[]{_i18nCheckStatusToolTip, _i18nRestartToolTip, _i18nStopToolTip}, false);
        this._buttons.addActionListener(this._btnListener);
        this._buttons.setBorder(new EmptyBorder(0, 10, 0, 0));
        gbc.setInsets(10, 0, 10, 0);
        gbc.setGrid(1, 1, 1, 1);
        gbc.setSpace(1.0, 0.0, 12, 2);
        p.add((Component)this._buttons, gbc);
        return p;
    }

    protected void checkStatus(ConsoleInfo ci, boolean init) {
        String taskURL = "admin-serv/tasks/Operation/SNMPControl?ACTION=STATUS";
        AdminOperation operation = new AdminOperation(ci, taskURL);
        StatusCheckListener listener = new StatusCheckListener(operation);
        operation.monitorOperation(_i18nDialogTitleStatus + " ...", listener);
        if (init || operation.getDialog() != null || operation.getFrame() != null) {
            return;
        }
        String title = _i18nDialogTitleStatus;
        DialogFrame dialog = new DialogFrame(this, title, operation.getPanel());
        ((Component)((Object)dialog)).setVisible(true);
        dialog.dispose();
        ModalDialogUtil.sleep();
    }

    protected void restart(ConsoleInfo ci) {
        String taskURL = "admin-serv/tasks/Operation/SNMPControl?ACTION=RESTART";
        AdminOperation operation = new AdminOperation(ci, taskURL);
        StopStartListener listener = new StopStartListener(operation, false);
        operation.monitorOperation("", listener);
        String title = _i18nDialogTitleRestart;
        DialogFrame dialog = new DialogFrame(this, title, operation.getPanel());
        ((Component)((Object)dialog)).setVisible(true);
        dialog.dispose();
        ModalDialogUtil.sleep();
    }

    protected void stop(ConsoleInfo ci) {
        String taskURL = "admin-serv/tasks/Operation/SNMPControl?ACTION=STOP";
        AdminOperation operation = new AdminOperation(ci, taskURL);
        StopStartListener listener = new StopStartListener(operation, true);
        operation.monitorOperation("", listener);
        String title = _i18nDialogTitleStop;
        DialogFrame dialog = new DialogFrame(this, title, operation.getPanel());
        ((Component)((Object)dialog)).setVisible(true);
        dialog.dispose();
        ModalDialogUtil.sleep();
    }

    static {
        _cmdStatus = "status";
        _cmdRestart = "restart";
        _cmdStop = "stop";
    }

    class StopStartListener
    implements IAdminOperationListener {
        AdminOperation _op;
        boolean _stop;

        public StopStartListener(AdminOperation op, boolean stop) {
            this._op = op;
            this._stop = stop;
        }

        public void cgiRequestCompleted(ConsoleInfo ci) {
            String tabStatus = _i18nUnknown;
            if (this._op.getResultStatus() == 0) {
                tabStatus = this._stop ? _i18nOff : _i18nOn;
            }
            String agent = (String)ci.get("SERVER_NAME");
            SNMPStatusPanel.this._statusTable.put(agent, tabStatus);
            SNMPStatusPanel.this.updateStatus(agent);
        }
    }

    class StatusCheckListener
    implements IAdminOperationListener {
        AdminOperation _op;

        public StatusCheckListener(AdminOperation op) {
            this._op = op;
        }

        public void cgiRequestCompleted(ConsoleInfo ci) {
            String tabStatus = _i18nUnknown;
            if (this._op.getResultStatus() == 0) {
                Hashtable res = this._op.getResultData();
                String statusAttr = (String)res.get("status");
                if (statusAttr == null) {
                    Debug.println((String)"status attr missing");
                } else {
                    tabStatus = statusAttr.equalsIgnoreCase("ON") ? _i18nOn : _i18nOff;
                }
            }
            String agent = (String)ci.get("SERVER_NAME");
            SNMPStatusPanel.this._statusTable.put(agent, tabStatus);
            SNMPStatusPanel.this.updateStatus(agent);
        }
    }
}

