/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.management.admserv.panel;

import com.netscape.management.admserv.config.ConfigPanelException;
import com.netscape.management.admserv.config.EditMonitor;
import com.netscape.management.admserv.config.IConfigDataModel;
import com.netscape.management.admserv.config.IPluginConfigPanel;
import com.netscape.management.admserv.config.ValidationException;
import com.netscape.management.client.console.ConsoleInfo;
import com.netscape.management.client.security.CipherPreferenceDialog;
import com.netscape.management.client.security.ClientAuthPanel;
import com.netscape.management.client.security.EncryptionOptions;
import com.netscape.management.client.security.EncryptionPanel;
import com.netscape.management.client.security.IClientAuthOptions;
import com.netscape.management.client.util.AdmTask;
import com.netscape.management.client.util.Debug;
import com.netscape.management.client.util.GridBagUtil;
import com.netscape.management.client.util.Help;
import com.netscape.management.client.util.ResourceSet;
import com.netscape.management.nmclf.SuiOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public class TurnOnSSL
implements IPluginConfigPanel,
EncryptionOptions,
IClientAuthOptions {
    static ResourceSet _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
    EditMonitor _monitor = null;
    ConsoleInfo _consoleInfo;
    JPanel encryptionPanel = null;
    Hashtable securitySettings = new Hashtable();
    EncryptionPanel _adminEncryptionPanel;
    boolean _isDirty = false;
    boolean _domestic = false;
    ClientAuthPanel _clientAuthPanel;
    static final String SSLV3 = "-rsa_null_md5,+rsa_rc4_40_md5,+rsa_rc2_40_md5,+rsa_rc4_128_md5,+rsa_des_sha,+rsa_3des_sha";
    static final String TLSV3 = "-rsa_null_md5,+rsa_rc4_40_md5,+rsa_rc2_40_md5,+rsa_rc4_128_md5,+rsa_des_sha,+rsa_3des_sha,+tls_rsa_export1024_with_des_cbc_sha,+tls_rsa_export1024_with_rc4_56_sha";
    static String _i18nMsgNoSslPreferences = _resource.getString("TurnOnSSL", "MsgNoSslPreferences");
    static String _i18nMsgNoSslFamily = _resource.getString("TurnOnSSL", "MsgNoSslFamily");
    static String _i18nMsgNoCertificate = _resource.getString("TurnOnSSL", "MsgNoCertificate");

    public void clientAuthSettingChanged(int type) {
        Debug.println((String)("TurnOnSSL:clientAuthSettingChanged:" + type));
        this.securitySettings.put("clientauth", type == 2 ? "on" : "off");
        this.setDirty(true);
    }

    public int getClientAuthSetting() {
        return this.securitySettings.get("clientauth").equals("on") ? 2 : 0;
    }

    public int[] getClientAuthUIOption() {
        int[] uiOptions = new int[]{0, 2};
        return uiOptions;
    }

    private void setDirty(boolean dirty) {
        if (this._monitor != null) {
            this._monitor.setDirtyFlag(dirty);
            this._isDirty = dirty;
        }
    }

    void changeSecuritySetting(String key, String val) {
        try {
            this.securitySettings.put(key, val);
            this.setDirty(true);
            if (key.equals("security")) {
                this._clientAuthPanel.setEnabled(val.equals("on"));
            }
        }
        catch (Exception e) {
            Debug.println((String)"TurnOnSSL: unable to change security setting");
        }
    }

    public void securityEnabledChanged(boolean enabled) {
        this.changeSecuritySetting("security", enabled ? "on" : "off");
        Debug.println((String)("Security enabled:" + (enabled ? "on" : "off")));
    }

    public void cipherFamilyEnabledChanged(String cipherFamily, boolean enabled) {
        Object familyList = this.securitySettings.get("familyList");
        if (familyList == null || familyList.toString().indexOf(cipherFamily) == -1) {
            String listString = familyList.toString();
            this.securitySettings.put("familyList", listString.length() > 0 ? listString + "," + cipherFamily : cipherFamily);
        }
        this.changeSecuritySetting(cipherFamily + "-activated", enabled ? "on" : "off");
        Debug.println((String)("Enable cipherFamily:" + cipherFamily + ":" + enabled));
    }

    public void selectedDeviceChanged(String cipherFamily, String device) {
        this.changeSecuritySetting(cipherFamily + "-token", device);
        Debug.println((String)("Selected device:" + cipherFamily + ":" + device));
    }

    public void selectedCertificateChanged(String cipherFamily, String certName) {
        this.changeSecuritySetting(cipherFamily + "-cert", certName);
        Debug.println((String)("Selected cert" + cipherFamily + ":" + certName));
    }

    public void showCipherPreferenceDialog(String cipherFamily) {
        Debug.println((String)("Show cipher preference dialog:" + cipherFamily));
        CipherPreferenceDialog cipherPref = null;
        cipherPref = cipherFamily.toLowerCase().equals("fortezza") ? new CipherPreferenceDialog(null, "", (String)this.securitySettings.get("ssl3"), ""){

            public void cipherStateChanged(String SSLVersion, String cipher, boolean enabled) {
                TurnOnSSL.this.setDirty(true);
            }
        } : new CipherPreferenceDialog(null, (String)this.securitySettings.get("ssl2"), (String)this.securitySettings.get("ssl3"), (String)this.securitySettings.get("tls")){

            public void cipherStateChanged(String SSLVersion, String cipher, boolean enabled) {
                TurnOnSSL.this.setDirty(true);
            }
        };
        cipherPref.setVisible(true);
        if (!cipherPref.isCancel()) {
            this.securitySettings.put("ssl2", cipherPref.getCipherPreference("V2"));
            this.securitySettings.put("ssl3", cipherPref.getCipherPreference("V3"));
            this.securitySettings.put("tls", cipherPref.getCipherPreference("TLS"));
            this.securitySettings.put("ssl2-activated", cipherPref.isSSLVersionEnabled("V2") ? "on" : "off");
            this.securitySettings.put("ssl3-activated", cipherPref.isSSLVersionEnabled("V3") ? "on" : "off");
            this.securitySettings.put("tls-activated", cipherPref.isSSLVersionEnabled("TLS") ? "on" : "off");
        }
    }

    public void setSecurityIsDomestic(boolean domestic) {
        this._domestic = domestic;
        Object ssl2Setting = this.securitySettings.get("ssl2");
        Object ssl3Setting = this.securitySettings.get("ssl2");
        Object tlsSetting = this.securitySettings.get("tls");
        CipherPreferenceDialog cipherPref = new CipherPreferenceDialog(null, true, true, true, domestic, false);
        if (ssl2Setting == null || ssl2Setting.toString().length() == 0 || ssl2Setting.toString().equals("blank")) {
            this.securitySettings.put("ssl2", cipherPref.getCipherPreference("V2"));
        }
        if (ssl3Setting == null || ssl3Setting.toString().length() == 0 || ssl3Setting.toString().equals("blank")) {
            this.securitySettings.put("ssl3", SSLV3);
        }
        if (tlsSetting == null || tlsSetting.toString().length() == 0 || tlsSetting.toString().equals("blank")) {
            this.securitySettings.put("tls", TLSV3);
        }
        Object ssl2On = this.securitySettings.get("ssl2-activated");
        Object ssl3On = this.securitySettings.get("ssl3-activated");
        Object tlsOn = this.securitySettings.get("tls-activated");
        if (ssl2On == null || ssl2On.toString().equals("blank") || ssl2On.toString().length() == 0) {
            this.securitySettings.put("ssl2-activated", "on");
        }
        if (ssl3On == null || ssl3On.toString().equals("blank") || ssl3On.toString().length() == 0) {
            this.securitySettings.put("ssl3-activated", "on");
        }
        if (tlsOn == null || tlsOn.toString().equals("blank") || tlsOn.toString().length() == 0) {
            this.securitySettings.put("tls-activated", "on");
        }
    }

    public boolean isSecurityEnabled() {
        boolean securityEnabled = false;
        try {
            securityEnabled = this.securitySettings.get("security").equals("on");
        }
        catch (Exception e) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        return securityEnabled;
    }

    public boolean isCipherFamilyEnabled(String cipherFamily) {
        boolean cipherFamilyEnabled = false;
        try {
            cipherFamilyEnabled = this.securitySettings.get(cipherFamily + "-activated").equals("on");
        }
        catch (Exception e) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        Debug.println((String)("Cipher family enabled:" + (cipherFamilyEnabled ? "true" : "false")));
        return cipherFamilyEnabled;
    }

    public String getSelectedCertificate(String cipherFamily) {
        String certName = "";
        try {
            certName = (String)this.securitySettings.get(cipherFamily + "-cert");
        }
        catch (Exception e) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        Debug.println((String)("Get selected cert:" + certName));
        return certName;
    }

    public String getSelectedDevice(String cipherFamily) {
        String deviceName = "";
        try {
            deviceName = (String)this.securitySettings.get(cipherFamily + "-token");
        }
        catch (Exception e) {
            Debug.println((String)"TurnOnSSL: no security setting");
        }
        Debug.println((String)("Get selected device:" + deviceName));
        return deviceName;
    }

    public TurnOnSSL(ConsoleInfo consoleInfo) {
        this._consoleInfo = consoleInfo;
        Debug.println((String)"TurnOnSSL:TurnOnSSL()");
        _resource = new ResourceSet("com.netscape.management.admserv.panel.panel");
        try {
            AdmTask task = new AdmTask(new URL(this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SSLActivate"), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
            task.exec();
            Debug.println((String)task.getResultString().toString());
            StringTokenizer st = new StringTokenizer(task.getResultString().toString(), "\n", false);
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int index = line.indexOf("=");
                if (index == -1) continue;
                String key = line.substring(0, index);
                Object val = this.securitySettings.get(key);
                String hashVal = line.substring(index + 1, line.length());
                if (val == null) {
                    this.securitySettings.put(key, hashVal.toLowerCase().equals("null") ? "" : hashVal);
                    continue;
                }
                if (hashVal.toString().toLowerCase().equals("null")) continue;
                this.securitySettings.put(key, val + "," + hashVal);
            }
        }
        catch (Exception e) {
            Debug.println((String)e.toString());
        }
        if (this.securitySettings.get("clientauth") == null || this.securitySettings.get("clientauth").toString().equals("")) {
            this.securitySettings.put("clientauth", "off");
        }
    }

    public String getTitleText() {
        return "";
    }

    public JPanel getPanel() {
        Debug.println((String)"TurnOnSSL:getPanel()");
        if (this.encryptionPanel == null) {
            this.encryptionPanel = new JPanel();
            this.encryptionPanel.setLayout(new GridBagLayout());
            this._adminEncryptionPanel = new EncryptionPanel(this._consoleInfo, (String)this._consoleInfo.get("SIE"), (EncryptionOptions)this);
            GridBagUtil.constrain((Container)this.encryptionPanel, (Component)this._adminEncryptionPanel, (int)0, (int)0, (int)1, (int)1, (double)1.0, (double)0.0, (int)18, (int)2, (int)0, (int)0, (int)0, (int)0);
            this._clientAuthPanel = new ClientAuthPanel((IClientAuthOptions)this);
            this._clientAuthPanel.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(6, 6, 6, 6)));
            GridBagUtil.constrain((Container)this.encryptionPanel, (Component)this._clientAuthPanel, (int)0, (int)1, (int)1, (int)1, (double)1.0, (double)0.0, (int)18, (int)2, (int)6, (int)0, (int)0, (int)0);
            GridBagUtil.constrain((Container)this.encryptionPanel, (Component)Box.createVerticalGlue(), (int)0, (int)1, (int)1, (int)1, (double)1.0, (double)1.0, (int)17, (int)3, (int)0, (int)0, (int)0, (int)0);
            Object clientAuthSetting = this.securitySettings.get("security");
            this._clientAuthPanel.setEnabled(clientAuthSetting == null ? false : clientAuthSetting.toString().equals("on"));
            this.setDirty(false);
        }
        return this.encryptionPanel;
    }

    public IConfigDataModel getDataModel() {
        return null;
    }

    public void setDataModel(IConfigDataModel datModel) throws ConfigPanelException {
    }

    public void initialize() throws ConfigPanelException {
    }

    public void registerEditComponents(EditMonitor monitor) {
        this._monitor = monitor;
    }

    public void resetContent() throws ConfigPanelException {
        this._adminEncryptionPanel.reset();
        this._clientAuthPanel.reset();
        Object clientAuthSetting = this.securitySettings.get("security");
        this._clientAuthPanel.setEnabled(clientAuthSetting == null ? false : clientAuthSetting.toString().equals("on"));
    }

    public void applyChanges() throws ValidationException {
        if (this._isDirty) {
            try {
                if (this.validEntries()) {
                    String adminURL = this._consoleInfo.getAdminURL() + "admin-serv/tasks/configuration/SSLActivate";
                    AdmTask task = new AdmTask(new URL(adminURL), this._consoleInfo.getAuthenticationDN(), this._consoleInfo.getAuthenticationPassword());
                    this.securitySettings.put("trustdb", (String)this._consoleInfo.get("SIE"));
                    Debug.printHashtable((String)"Security Setting", (Hashtable)this.securitySettings);
                    task.setArguments(this.securitySettings);
                    task.exec();
                    Debug.println((String)task.getResultString().toString());
                    StringTokenizer st = new StringTokenizer(task.getResultString().toString(), "\n", false);
                    if (task.getResult().get("NMC_Description") != null) {
                        this._adminEncryptionPanel.setSaved();
                        this._clientAuthPanel.setSaved();
                        SuiOptionPane.showMessageDialog((Component)new JFrame(), task.getResult().get("NMC_Description"));
                    } else if (task.getResult().get("NMC_ErrType") != null) {
                        SuiOptionPane.showMessageDialog((Component)new JFrame(), (Object)(task.getResult().get("NMC_ErrType") + "\n\n" + task.getResult().get("NMC_ErrInfo") + (task.getResult().get("NMC_ErrDetail") != null ? "\n" + task.getResult().get("NMC_ErrDetail") : "")));
                    }
                    this.setDirty(false);
                }
            }
            catch (ValidationException ve) {
                throw ve;
            }
            catch (Exception e) {
                Debug.println((String)("TurnOnSSL.applyChanges: ERROR - " + e.toString()));
            }
        }
    }

    private boolean validEntries() throws ValidationException {
        Object error = null;
        boolean valid = true;
        int howManyEnabled = 0;
        int howManyNoDevice = 0;
        int howManyNoCertif = 0;
        if (this.securitySettings.get("security").equals("on")) {
            StringTokenizer st = new StringTokenizer((String)this.securitySettings.get("familyList"), ",");
            if (st.countTokens() != 0) {
                while (st.hasMoreTokens()) {
                    try {
                        String cipherFamily = st.nextToken();
                        String val = (String)this.securitySettings.get(cipherFamily + "-activated");
                        if (val == null || !val.equals("on")) continue;
                        ++howManyEnabled;
                        val = (String)this.securitySettings.get(cipherFamily + "-token");
                        if (val == null) {
                            ++howManyNoDevice;
                        }
                        if ((val = (String)this.securitySettings.get(cipherFamily + "-cert")) != null) continue;
                        ++howManyNoCertif;
                    }
                    catch (NoSuchElementException nsee) {
                        Debug.println((String)"TurnOnSSL.validateEntries: Unable to read family cipher token");
                    }
                }
            } else {
                Debug.println((String)"TurnOnSSL.validateEntries: no family ciphers");
            }
            if (howManyEnabled == 0) {
                valid = false;
                throw new ValidationException("", _i18nMsgNoSslFamily);
            }
            if (howManyNoDevice >= 1) {
                valid = false;
                throw new ValidationException("", _i18nMsgNoSslPreferences);
            }
            if (howManyNoCertif >= 1) {
                valid = false;
                throw new ValidationException("", _i18nMsgNoCertificate);
            }
        } else {
            Debug.println((int)6, (String)"TurnOnSSL.validateEntries: SSL is off");
        }
        return valid;
    }

    public void showHelp() {
        Help help = new Help(_resource);
        help.contextHelp("TurnOnSSL", "help");
    }
}

