/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.packaging;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.packaging.DirFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public class Solaris_Package
implements InstanceProvider {
    private CIMOMHandle cimomhandle = null;
    private ProviderUtility provUtil = null;
    public static final String PROVIDER_NAME = "Solaris_Package";
    public static final String PKGINFO_DIR = "/var/sadm/pkg";
    public static final String PKGINFO_FILE = "pkginfo";
    public static final String PATH_SEP = "/";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = cIMOMHandle;
        this.provUtil = new ProviderUtility(cIMOMHandle, PROVIDER_NAME);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance cIMInstance;
        block5: {
            String string = "";
            cIMInstance = null;
            try {
                Object object;
                Enumeration enumeration = cIMObjectPath.getKeys().elements();
                while (enumeration.hasMoreElements()) {
                    object = (CIMProperty)enumeration.nextElement();
                    if (!object.getName().equalsIgnoreCase("name")) continue;
                    string = (String)object.getValue().getValue();
                }
                cIMInstance = cIMClass.newInstance();
                if (this.validatePkgExists(string)) {
                    cIMInstance.setProperty("Name", new CIMValue((Object)string));
                    cIMInstance.setProperty("TargetOperatingSystem", new CIMValue((Object)new UnsignedInt16(29)));
                    cIMInstance.setProperty("Status", new CIMValue((Object)this.GetPkgStatus(string)));
                    cIMInstance.setProperty("Architecture", new CIMValue((Object)this.GetPkgArchitecture(string)));
                    cIMInstance.setProperty("Description", new CIMValue((Object)this.GetPkgDescription(string)));
                    cIMInstance.setProperty("Caption", new CIMValue((Object)this.GetPkgDescription(string)));
                    cIMInstance.setProperty("Manufacturer", new CIMValue((Object)this.GetPkgVendor(string)));
                    cIMInstance.setProperty("Category", new CIMValue((Object)this.GetPkgCategory(string)));
                    cIMInstance.setProperty("Basedir", new CIMValue((Object)this.GetPkgBasedir(string)));
                    object = this.getPkgInfo(string);
                    cIMInstance.setProperty("SupportInfo", new CIMValue((Object)this.getPkgInfoValue((Vector)object, "HOTLINE", string)));
                    cIMInstance.setProperty("OtherTargetOS", new CIMValue((Object)"none"));
                    cIMInstance.setProperty("IdentificationCode", new CIMValue((Object)this.getPkgInfoValue((Vector)object, "PSTAMP", string)));
                    Calendar calendar = this.convertDate(this.getPkgInfoValue((Vector)object, "INSTDATE", string));
                    CIMDateTime cIMDateTime = new CIMDateTime(calendar);
                    cIMInstance.setProperty("InstallDate", new CIMValue((Object)cIMDateTime));
                    String string2 = this.GetPkgVersion(string);
                    cIMInstance.setProperty("Version", new CIMValue((Object)this.getVersion(string2, string)));
                    cIMInstance.setProperty("BuildNumber", new CIMValue((Object)this.getBuildNumber(string2, string)));
                    break block5;
                }
                return cIMInstance;
            }
            catch (Exception exception) {
                this.provUtil.writeLog(2, "LM_10400", "LM_104001", null, null, null, null);
            }
        }
        if (bl) {
            cIMInstance = cIMInstance.localElements();
        }
        return cIMInstance.filterProperties(stringArray, bl2, bl3);
    }

    public synchronized CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        CIMObjectPath[] cIMObjectPathArray;
        Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
        try {
            cIMObjectPathArray = new File(PKGINFO_DIR);
            DirFilter dirFilter = new DirFilter();
            String[] stringArray = cIMObjectPathArray.list(dirFilter);
            int n = 0;
            while (n < stringArray.length) {
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey("Name", new CIMValue((Object)stringArray[n]));
                cIMObjectPath2.addKey("Version", new CIMValue((Object)this.getVersion(this.getVersion(this.GetPkgVersion(stringArray[n]), stringArray[n]), stringArray[n])));
                cIMObjectPath2.addKey("TargetOperatingSystem", new CIMValue((Object)new UnsignedInt16(29)));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10450", "LM_10451", PROVIDER_NAME, PKGINFO_DIR, null, null);
        }
        cIMObjectPathArray = new CIMObjectPath[vector.size()];
        vector.toArray(cIMObjectPathArray);
        return cIMObjectPathArray;
    }

    public synchronized CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        Vector<CIMInstance> vector = new Vector<CIMInstance>();
        try {
            cIMInstanceArray = new File(PKGINFO_DIR);
            DirFilter dirFilter = new DirFilter();
            String[] stringArray2 = cIMInstanceArray.list(dirFilter);
            int n = 0;
            while (n < stringArray2.length) {
                String string = stringArray2[n];
                CIMInstance cIMInstance = cIMClass.newInstance();
                cIMInstance.setProperty("Name", new CIMValue((Object)string));
                cIMInstance.setProperty("TargetOperatingSystem", new CIMValue((Object)new UnsignedInt16(29)));
                cIMInstance.setProperty("Status", new CIMValue((Object)this.GetPkgStatus(string)));
                cIMInstance.setProperty("Architecture", new CIMValue((Object)this.GetPkgArchitecture(string)));
                cIMInstance.setProperty("Description", new CIMValue((Object)this.GetPkgDescription(string)));
                cIMInstance.setProperty("Caption", new CIMValue((Object)this.GetPkgDescription(string)));
                cIMInstance.setProperty("Manufacturer", new CIMValue((Object)this.GetPkgVendor(string)));
                cIMInstance.setProperty("Category", new CIMValue((Object)this.GetPkgCategory(string)));
                cIMInstance.setProperty("Basedir", new CIMValue((Object)this.GetPkgBasedir(string)));
                Vector vector2 = this.getPkgInfo(string);
                cIMInstance.setProperty("SupportInfo", new CIMValue((Object)this.getPkgInfoValue(vector2, "HOTLINE", string)));
                cIMInstance.setProperty("OtherTargetOS", new CIMValue((Object)"none"));
                cIMInstance.setProperty("IdentificationCode", new CIMValue((Object)this.getPkgInfoValue(vector2, "PSTAMP", string)));
                Date date = new Date(this.getPkgInfoValue(vector2, "INSTDATE", string));
                CIMDateTime cIMDateTime = new CIMDateTime(date);
                cIMInstance.setProperty("InstallDate", new CIMValue((Object)cIMDateTime));
                String string2 = this.GetPkgVersion(string);
                cIMInstance.setProperty("Version", new CIMValue((Object)this.getVersion(string2, string)));
                cIMInstance.setProperty("BuildNumber", new CIMValue((Object)this.getBuildNumber(string2, string)));
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
                ++n;
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, "LM_10450", "LM_10451", PROVIDER_NAME, PKGINFO_DIR, null, null);
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    public synchronized Vector getPkgInfo(String string) {
        File file = new File("/var/sadm/pkg/" + string + PATH_SEP + PKGINFO_FILE);
        Vector<String> vector = new Vector<String>();
        try {
            if (file.exists() && file.isFile() && file.canRead()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                int n = 0;
                while (string2 != null) {
                    n = string2.indexOf("=");
                    if (n != -1) {
                        String string3 = string2.substring(0, n);
                        String string4 = string2.substring(n + 1, string2.length());
                        string3 = string3.trim();
                        string4 = string4.trim();
                        vector.addElement(string3);
                        vector.addElement(string4);
                    }
                    string2 = bufferedReader.readLine();
                }
                bufferedReader.close();
                return vector;
            }
            this.provUtil.writeLog(2, "LM_10452", "LM_10453", PROVIDER_NAME, "/var/sadm/pkg/" + string, null, null);
            return null;
        }
        catch (Exception exception) {
            this.provUtil.writeLog(2, exception);
            return null;
        }
    }

    public String getPkgInfoValue(Vector vector, String string, String string2) {
        try {
            int n = vector.indexOf(string);
            if (n != -1) {
                return (String)vector.elementAt(n + 1);
            }
            this.provUtil.writeLog(1, "LM_10454", "LM_10455", PROVIDER_NAME, string, string2, null);
            return "";
        }
        catch (Exception exception) {
            this.provUtil.writeLog(1, exception);
            return "";
        }
    }

    private String getVersion(String string, String string2) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf(",");
            if (n != -1) {
                return string.substring(0, n);
            }
            return string;
        }
        this.provUtil.writeLog(1, "LM_10456", "LM_10457", PROVIDER_NAME, string2, null, null);
        return "";
    }

    private String getBuildNumber(String string, String string2) {
        if (string != null && string.length() > 0) {
            int n = string.indexOf(",");
            if (n != -1) {
                return string.substring(n + 1, string.length());
            }
            this.provUtil.writeLog(1, "LM_10458", "LM_10459", PROVIDER_NAME, string2, null, null);
            return "";
        }
        this.provUtil.writeLog(1, "LM_10458", "LM_10459", PROVIDER_NAME, string2, null, null);
        return "";
    }

    private Calendar convertDate(String string) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 1, 1, 0, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[]{"Jan", "01", "2000", "00", "00"};
        int n = 0;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (n < 2) {
                    stringArray[n] = string2;
                    ++n;
                    continue;
                }
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
                while (stringTokenizer2.hasMoreTokens()) {
                    stringArray[n] = stringTokenizer2.nextToken();
                    ++n;
                }
            }
            if (n == 5) {
                calendar.set(Integer.parseInt(stringArray[2]), this.convertMonth(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[3]), Integer.parseInt(stringArray[4]));
            }
        }
        catch (Exception exception) {
            this.provUtil.writeLog(1, exception);
        }
        return calendar;
    }

    private int convertMonth(String string) {
        if ((string = string.trim()).equalsIgnoreCase("Jan")) {
            return 0;
        }
        if (string.equalsIgnoreCase("Feb")) {
            return 1;
        }
        if (string.equalsIgnoreCase("Mar")) {
            return 2;
        }
        if (string.equalsIgnoreCase("Apr")) {
            return 3;
        }
        if (string.equalsIgnoreCase("May")) {
            return 4;
        }
        if (string.equalsIgnoreCase("Jun")) {
            return 5;
        }
        if (string.equalsIgnoreCase("Jul")) {
            return 6;
        }
        if (string.equalsIgnoreCase("Aug")) {
            return 7;
        }
        if (string.equalsIgnoreCase("Sep")) {
            return 8;
        }
        if (string.equalsIgnoreCase("Oct")) {
            return 9;
        }
        if (string.equalsIgnoreCase("Nov")) {
            return 10;
        }
        if (string.equalsIgnoreCase("Dec")) {
            return 11;
        }
        return 1;
    }

    private boolean validatePkgExists(String string) {
        boolean bl = false;
        if (string == null || string.length() == 0) {
            return bl;
        }
        try {
            File file = new File(PKGINFO_DIR);
            DirFilter dirFilter = new DirFilter();
            String[] stringArray = file.list(dirFilter);
            int n = 0;
            while (n < stringArray.length) {
                if (string.equals(stringArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public synchronized String getPkgStatus(String string) {
        return this.GetPkgStatus(string);
    }

    synchronized native String GetPkgDescription(String var1);

    synchronized native String GetPkgArchitecture(String var1);

    synchronized native String GetPkgVersion(String var1);

    synchronized native String GetPkgVendor(String var1);

    synchronized native String GetPkgBasedir(String var1);

    synchronized native String GetPkgCategory(String var1);

    synchronized native String GetPkgStatus(String var1);

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        return null;
    }

    static {
        System.loadLibrary("solprov");
    }
}

