/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.patch.PatchException;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.ProviderCIMOMHandle;

public class SetClasspath {
    private static final String SOLARIS_PROVIDER_PATH = "Solaris_ProviderPath";
    private static final String SOLARIS_PKG = "Solaris_Package";
    private static final String NAME_PROP = "Name";
    private static final String BASEDIR_PROP = "BaseDir";
    private static final String[] NEEDED_PROPS = new String[]{"BaseDir"};
    private static final String FILE_PREFIX = "file://";
    private static final int NUM_JARS = 3;
    private static String[] PKGS = new String[]{"SUNWppro", "SUNWsdb", "SUNWapcy"};
    private static String[] JARS = new String[]{"/lib/patchpro.jar", "/lib/simpledb.jar", "/lib/authpcy.jar"};
    private static final String PATHURL = "pathurl";
    private static final String NAME_SPACE = "root/system";
    private static final String CIMV2_NAMESPACE = "root/cimv2";

    public static void setPProClasspath(ProviderCIMOMHandle providerCIMOMHandle) throws PatchException, CIMException {
        if (providerCIMOMHandle == null) {
            throw new PatchException("EXM_INVALID_CIMOM_HANDLE");
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath(SOLARIS_PROVIDER_PATH, NAME_SPACE);
        if (cIMObjectPath == null) {
            throw new PatchException("EXM_FAIL_CREATE_CIMOP", SOLARIS_PROVIDER_PATH);
        }
        CIMClass cIMClass = providerCIMOMHandle.getClass(cIMObjectPath, true, false, false, null);
        if (cIMClass == null) {
            throw new PatchException("EXM_FAIL_CREATE_CIMCLASS", SOLARIS_PROVIDER_PATH);
        }
        String[] stringArray = SetClasspath.getPProJars(providerCIMOMHandle);
        if (stringArray == null) {
            throw new PatchException("EXM_NO_PPRO_JARS");
        }
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath2 = null;
        int n = 0;
        while (n < 3) {
            cIMObjectPath2 = new CIMObjectPath(SOLARIS_PROVIDER_PATH, NAME_SPACE);
            cIMObjectPath2.addKey(PATHURL, new CIMValue((Object)stringArray[n]));
            try {
                cIMInstance = providerCIMOMHandle.getInstance(cIMObjectPath2, true, false, false, null);
            }
            catch (CIMException cIMException) {
                if (!cIMException.getID().equals("CIM_ERR_NOT_FOUND")) {
                    throw new CIMProviderException("CIM_ERR_FAILED", (Object)cIMException.getLocalizedMessage());
                }
            }
            catch (Exception exception) {
                throw new PatchException("EXM_NO_PPRO_JARS");
            }
            if (cIMInstance == null) {
                try {
                    cIMInstance = cIMClass.newInstance();
                    cIMInstance.setProperty(PATHURL, new CIMValue((Object)stringArray[n]));
                    providerCIMOMHandle.createInstance(cIMObjectPath2, cIMInstance);
                }
                catch (Exception exception) {
                    throw new CIMProviderException("CIM_ERR_FAILED", (Object)exception.getLocalizedMessage());
                }
            }
            cIMInstance = null;
            ++n;
        }
    }

    private static String[] getPProJars(ProviderCIMOMHandle providerCIMOMHandle) throws PatchException, CIMException {
        CIMObjectPath cIMObjectPath = null;
        CIMInstance cIMInstance = null;
        String string = null;
        String[] stringArray = new String[3];
        int n = 0;
        while (n < 3) {
            try {
                cIMObjectPath = new CIMObjectPath(SOLARIS_PKG, CIMV2_NAMESPACE);
                if (cIMObjectPath == null) {
                    return null;
                }
                cIMObjectPath.addKey(NAME_PROP, new CIMValue((Object)PKGS[n]));
                cIMInstance = providerCIMOMHandle.getInstance(cIMObjectPath, true, false, false, NEEDED_PROPS);
                if (cIMInstance == null) {
                    return null;
                }
                string = SetClasspath.getValue(BASEDIR_PROP, cIMInstance);
                if (string == null) {
                    return null;
                }
                stringArray[n] = FILE_PREFIX + string + JARS[n];
            }
            catch (CIMException cIMException) {
                if (cIMException.getID().equals("CIM_ERR_NOT_FOUND")) {
                    throw new PatchException("EXM_NO_PPRO_JARS");
                }
                throw new CIMProviderException("CIM_ERR_FAILED", (Object)cIMException.getLocalizedMessage());
            }
            catch (Exception exception) {
                throw new PatchException("EXM_NO_PPRO_JARS");
            }
            ++n;
        }
        return stringArray;
    }

    private static String getKeyValue(String string, CIMObjectPath cIMObjectPath) {
        try {
            String string2 = null;
            Vector vector = cIMObjectPath.getKeys();
            if (vector == null) {
                return null;
            }
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (cIMProperty == null || (string2 = cIMProperty.getName()) == null || !string.equalsIgnoreCase(string2)) continue;
                CIMValue cIMValue = cIMProperty.getValue();
                if (cIMValue != null) {
                    return (String)cIMValue.getValue();
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String getValue(String string, CIMInstance cIMInstance) throws CIMProviderException {
        try {
            CIMValue cIMValue = cIMInstance.getProperty(string).getValue();
            if (cIMValue != null) {
                return cIMValue.getValue().toString();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }
}

