/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cim;

import com.sun.wbem.cim.MOFFormatter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CIMDateTime
implements Serializable {
    static final long serialVersionUID = 200L;
    private Calendar cal;
    private boolean isInterval = false;

    public CIMDateTime() {
        this(new Date());
    }

    public CIMDateTime(Date date) {
        this.cal = Calendar.getInstance();
        this.cal.setTime(date);
    }

    public CIMDateTime(Calendar calendar) {
        this.cal = calendar;
    }

    public CIMDateTime(String string) {
        this.cal = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
        simpleDateFormat.setLenient(false);
        try {
            Date date = simpleDateFormat.parse(string.substring(0, 18));
            this.cal.setTime(date);
            if (string.charAt(21) == ':') {
                this.isInterval = true;
            } else {
                Integer n = null;
                n = string.charAt(21) == '+' ? Integer.valueOf(string.substring(22)) : Integer.valueOf(string.substring(21));
                TimeZone timeZone = TimeZone.getTimeZone("GMT");
                timeZone.setRawOffset(n * 60 * 1000);
                this.cal.setTimeZone(timeZone);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mOFFormatter = new MOFFormatter();
        return mOFFormatter.toString(this);
    }

    public boolean after(CIMDateTime cIMDateTime) {
        return this.cal.after(cIMDateTime.getCalendar());
    }

    public boolean before(CIMDateTime cIMDateTime) {
        return this.cal.before(cIMDateTime.getCalendar());
    }

    public boolean equals(Object object) {
        return this.cal.equals(((CIMDateTime)object).getCalendar());
    }

    public Calendar getCalendar() {
        return this.cal;
    }
}

