/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.host.Realization;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchInfo;
import com.sun.patchpro.patch.PatchProperties;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchInfoImpl
implements PatchInfo {
    private String synopsis = "";
    private String obsolesces = "";
    private String requires = "";
    private String incompat = "";
    private String prefers = "";
    private String constraint;
    private String architecture;
    private String operatingSystem;
    private String release;
    private String type = new String("SunPatch");
    private PatchProperties properties;
    private PatchID obsolescedBy = null;
    private Vector realizations = null;
    ObjectFilter realizationFilter = new ObjectFilter(){

        public String filter(Object object) {
            Realization realization = (Realization)object;
            return realization.getRealizationString();
        }
    };
    ObjectFilter patchFilter = new ObjectFilter(){

        public String filter(Object object) {
            PatchID patchID = (PatchID)object;
            return patchID.getPatchID();
        }
    };
    ObjectFilter stringFilter = new ObjectFilter(){

        public String filter(Object object) {
            return (String)object;
        }
    };

    public PatchInfoImpl() {
        this.realizations = new Vector();
        this.properties = new PatchProperties("");
    }

    public PatchInfoImpl(PatchInfo patchInfo) {
        this();
        Enumeration enumeration = patchInfo.getRealizations();
        while (enumeration.hasMoreElements()) {
            this.addRealization((Realization)enumeration.nextElement());
        }
        this.setSynopsis(patchInfo.getSynopsis());
        try {
            this.setObsoletes(patchInfo.getObsolesces());
        }
        catch (MalformedPatchException malformedPatchException) {
            // empty catch block
        }
        try {
            this.setRequires(patchInfo.getRequires());
        }
        catch (MalformedPatchException malformedPatchException) {
            // empty catch block
        }
        try {
            this.setIncompat(patchInfo.getIncompat());
        }
        catch (MalformedPatchException malformedPatchException) {
            // empty catch block
        }
        try {
            this.setPrefers(patchInfo.getPrefers());
        }
        catch (MalformedPatchException malformedPatchException) {
            // empty catch block
        }
        this.setConstraint(patchInfo.getConstraint());
        this.setArchitecture(patchInfo.getArchitecture());
        this.setOS(patchInfo.getOS());
        this.setRelease(patchInfo.getRelease());
        this.setProperties(patchInfo.getProperties());
        this.setType(patchInfo.getType());
        try {
            this.setObsoletedBy(patchInfo.getObsolescedBy());
        }
        catch (NoSuchPatchException noSuchPatchException) {
            // empty catch block
        }
    }

    public Enumeration getRealizations() {
        return this.realizations.elements();
    }

    public PatchID getObsolescedBy() throws NoSuchPatchException {
        return this.getObsoletedBy();
    }

    public PatchID getObsoletedBy() throws NoSuchPatchException {
        if (this.obsolescedBy == null) {
            throw new NoSuchPatchException("PatchInfo.getObsolescedBy(): No obsolescing patch.");
        }
        return this.obsolescedBy;
    }

    public String getObsolesces() {
        return this.getObsoletes();
    }

    public String getObsoletes() {
        return this.obsolesces;
    }

    public String getRequires() {
        return this.requires;
    }

    public String getIncompat() {
        return this.incompat;
    }

    public String getPrefers() {
        return this.prefers;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getOS() {
        return this.operatingSystem;
    }

    public String getRelease() {
        return this.release;
    }

    public PatchProperties getProperties() {
        return this.properties;
    }

    public String getSynopsis() {
        return this.synopsis;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(PatchInfo patchInfo) {
        Exception exception = new Exception();
        try {
            block35: {
                String string;
                String string2;
                block34: {
                    Vector vector;
                    Vector vector2;
                    String string3;
                    block33: {
                        block32: {
                            block31: {
                                if (this.synopsis != null && patchInfo.getSynopsis() != null) {
                                    string2 = this.synopsis.trim();
                                    string = patchInfo.getSynopsis().trim();
                                    if (string2 != "" && string != "" ? !string2.equals(string) : string2.compareTo(string) != 0) {
                                        throw exception;
                                    }
                                }
                                if (this.realizations != null && patchInfo.getRealizations() != null ? !this.isBijective(this.realizations, patchInfo.getRealizations(), this.realizationFilter) : this.realizations != null || patchInfo.getRealizations() != null) {
                                    throw exception;
                                }
                                try {
                                    string3 = patchInfo.getObsolesces();
                                    if (!PatchInfoImpl.isExpressionEqual(this.obsolesces, string3) && !this.isBijective(vector2 = this.stringToVector(this.obsolesces), (vector = this.stringToVector(string3)).elements(), this.patchFilter)) {
                                        throw exception;
                                    }
                                }
                                catch (NoSuchPatchException noSuchPatchException) {
                                    if (this.obsolesces == null) break block31;
                                    throw exception;
                                }
                            }
                            try {
                                string3 = patchInfo.getRequires();
                                if (!PatchInfoImpl.isExpressionEqual(this.requires, string3) && !this.isBijective(vector2 = this.stringToVector(this.requires), (vector = this.stringToVector(string3)).elements(), this.patchFilter)) {
                                    throw exception;
                                }
                            }
                            catch (NoSuchPatchException noSuchPatchException) {
                                if (this.requires == null) break block32;
                                throw exception;
                            }
                        }
                        try {
                            string3 = patchInfo.getIncompat();
                            if (!PatchInfoImpl.isExpressionEqual(this.incompat, string3) && !this.isBijective(vector2 = this.stringToVector(this.incompat), (vector = this.stringToVector(string3)).elements(), this.patchFilter)) {
                                throw exception;
                            }
                        }
                        catch (NoSuchPatchException noSuchPatchException) {
                            if (this.incompat == null) break block33;
                            throw exception;
                        }
                    }
                    try {
                        string3 = patchInfo.getPrefers();
                        if (!PatchInfoImpl.isExpressionEqual(this.prefers, string3) && !this.isBijective(vector2 = this.stringToVector(this.prefers), (vector = this.stringToVector(string3)).elements(), this.patchFilter)) {
                            throw exception;
                        }
                    }
                    catch (NoSuchPatchException noSuchPatchException) {
                        if (this.prefers == null) break block34;
                        throw exception;
                    }
                }
                if (this.constraint != null && patchInfo.getConstraint() != null) {
                    string2 = this.constraint.trim();
                    string = patchInfo.getConstraint().trim();
                    if (string2 != "" && string != "" ? !PatchInfoImpl.isExpressionEqual(string2, string) : string2.compareTo(string) != 0) {
                        throw exception;
                    }
                }
                if (this.architecture != null && patchInfo.getArchitecture() != null) {
                    string2 = this.architecture.trim();
                    string = patchInfo.getArchitecture().trim();
                    if (string2 != "" && string != "" ? !string2.equals(string) : string2.compareTo(string) != 0) {
                        throw exception;
                    }
                }
                if (this.operatingSystem != null && patchInfo.getOS() != null) {
                    string2 = this.operatingSystem.trim();
                    string = patchInfo.getOS().trim();
                    if (string2 != "" && string != "" ? !string2.equals(string) : string2.compareTo(string) != 0) {
                        throw exception;
                    }
                }
                if (this.type != null && patchInfo.getType() != null) {
                    string2 = this.type.trim();
                    string = patchInfo.getType().trim();
                    if (string2 != "" && string != "" ? !string2.equals(string) : string2.compareTo(string) != 0) {
                        throw exception;
                    }
                }
                if (this.release != null && patchInfo.getRelease() != null) {
                    string2 = this.release.trim();
                    string = patchInfo.getRelease().trim();
                    if (string2 != "" && string != "" ? !PatchInfoImpl.isStringListEqual(this.release, patchInfo.getRelease()) : string2.compareTo(string) != 0) {
                        throw exception;
                    }
                }
                if (this.properties != null && patchInfo.getProperties() != null ? !this.properties.equals(patchInfo.getProperties()) : this.properties != null || patchInfo.getProperties() != null) {
                    throw exception;
                }
                try {
                    if (this.obsolescedBy != null && patchInfo.getObsolescedBy() != null && !this.obsolescedBy.equals(patchInfo.getObsolescedBy())) {
                        throw exception;
                    }
                }
                catch (NoSuchPatchException noSuchPatchException) {
                    if (this.obsolescedBy == null) break block35;
                    throw exception;
                }
            }
            return true;
        }
        catch (Exception exception2) {
            return false;
        }
    }

    public void setSynopsis(String string) {
        this.synopsis = string;
    }

    public void addRealization(Realization realization) {
        this.realizations.addElement(realization);
    }

    public void setObsolesces(String string) throws MalformedPatchException {
        this.setObsoletes(string);
    }

    public void setObsoletes(String string) throws MalformedPatchException {
        this.obsolesces = string;
    }

    public void setRequires(String string) throws MalformedPatchException {
        this.requires = string;
    }

    public void setIncompat(String string) throws MalformedPatchException {
        this.incompat = string;
    }

    public void setPrefers(String string) throws MalformedPatchException {
        this.prefers = string;
    }

    public void setConstraint(String string) {
        this.constraint = string;
    }

    public void setArchitecture(String string) {
        this.architecture = string;
    }

    public void setOS(String string) {
        this.operatingSystem = string;
    }

    public void setRelease(String string) {
        this.release = string;
    }

    public void setProperties(PatchProperties patchProperties) {
        this.properties = patchProperties;
    }

    public void setObsoletedBy(PatchID patchID) {
        this.obsolescedBy = patchID;
    }

    public void setObsolescedBy(PatchID patchID) {
        this.setObsoletedBy(patchID);
    }

    public void setType(String string) {
        if (string != null && string.length() > 0) {
            this.type = string;
        }
    }

    public static boolean isExpressionEqual(String string, String string2) {
        boolean bl = false;
        String string3 = string.trim();
        String string4 = string2.trim();
        if (string3.startsWith("(") && string4.startsWith("(") && string3.equals(string4)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isStringListEqual(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
        if (stringTokenizer.countTokens() == stringTokenizer2.countTokens()) {
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer3 = new StringTokenizer(string2, " ");
                boolean bl = false;
                while (stringTokenizer3.hasMoreTokens() && !bl) {
                    String string4 = stringTokenizer3.nextToken();
                    if (!string3.equals(string4)) continue;
                    bl = true;
                }
                if (bl) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean isBijective(Vector vector, Enumeration enumeration, ObjectFilter objectFilter) {
        Enumeration enumeration2 = enumeration;
        int n = 0;
        while (enumeration2.hasMoreElements()) {
            String string = objectFilter.filter(enumeration2.nextElement());
            boolean bl = false;
            int n2 = 0;
            while (n2 < vector.size() && !bl) {
                String string2 = objectFilter.filter(vector.elementAt(n2));
                if (string2.compareTo(string) == 0) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return n == vector.size();
    }

    private Vector stringToVector(String string) throws MalformedPatchException {
        Vector<PatchID> vector = new Vector<PatchID>();
        if (string != null) {
            string = string.replace(',', ' ');
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            while (stringTokenizer.hasMoreElements()) {
                vector.addElement(new PatchID(stringTokenizer.nextToken()));
            }
        }
        return vector;
    }

    protected static interface ObjectFilter
    extends Serializable {
        public String filter(Object var1);
    }
}

