/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom;

import com.sun.wbem.cimom.CIMOMProvider;
import com.sun.wbem.cimom.InternalProviderAdapter;
import com.sun.wbem.cimom.OneToManyAssocProvider;
import com.sun.wbem.cimom.adapter.provider.ProviderAdapterIF;
import com.sun.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import com.sun.wbem.cimom.util.DynClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMPropertyException;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.CIMAssociatorProvider;
import javax.wbem.provider.CIMIndicationProvider;
import javax.wbem.provider.CIMInstanceProvider;
import javax.wbem.provider.CIMMethodProvider;
import javax.wbem.provider.CIMProvider;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.PropertyProvider;

public class ProviderAdapterFactory
implements InternalProviderAdapter.InternalServiceProvider {
    private Map mAdapters = null;
    private Map mProviders = null;
    private List serviceProviders = new ArrayList();
    private ProviderCIMOMHandle mCimom = null;
    private boolean mShouldReturnNull = false;
    private static final String PPACIMCLASS = "WBEMServices_ObjectManagerProviderProtocolAdapter";
    private static final String PPA_ASSOC_CLASS = "WBEMServices_ProviderProtocolAdapterForManager";
    private static final String STARTSERVICE = "StartService";
    private static final String STOPSERVICE = "StopService";
    private static final String PROTOCOLTYPE = "Name";
    private static final String IMPLCLASS = "ImplClass";
    private static final String CLASSPATH = "classPath";
    AdapterProvider adapterProvider;
    AdapterAssocProvider assocProvider;

    public String[] getProviderNames() {
        this.serviceProviders.add(PPACIMCLASS);
        this.serviceProviders.add(PPA_ASSOC_CLASS);
        String[] stringArray = new String[this.serviceProviders.size()];
        return this.serviceProviders.toArray(stringArray);
    }

    public CIMProvider getProvider(String string) throws CIMException {
        if (string.equals(PPACIMCLASS)) {
            return this.adapterProvider;
        }
        if (string.equals(PPA_ASSOC_CLASS)) {
            return this.assocProvider;
        }
        return (CIMProvider)this.mAdapters.get(string);
    }

    public ProviderAdapterFactory(ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        this.mCimom = providerCIMOMHandle;
        String string = System.getProperty("passAllProviderCheck", "false");
        if ("true".equalsIgnoreCase(string)) {
            this.mShouldReturnNull = true;
            Debug.trace3((String)"'passAllProviderCheck' was true");
        } else {
            this.mShouldReturnNull = false;
            this.mAdapters = Collections.synchronizedMap(new HashMap(5));
            this.mProviders = Collections.synchronizedMap(new HashMap(100));
            this.adapterProvider = new AdapterProvider();
            this.assocProvider = new AdapterAssocProvider();
            Debug.trace3((String)"Provider factory created and ready");
        }
    }

    void RegisterProtocolProvider(String string, ProviderProtocolAdapterIF providerProtocolAdapterIF, boolean bl) {
        if (this.mShouldReturnNull) {
            return;
        }
        this.UnRegisterProtocolProvider(string);
        providerProtocolAdapterIF.initialize(this.mCimom);
        if (bl) {
            providerProtocolAdapterIF.start();
        }
        if (providerProtocolAdapterIF.isValid()) {
            Debug.trace3((String)("adding an adapter for protocol: " + string));
            this.mAdapters.put(string, providerProtocolAdapterIF);
            if (providerProtocolAdapterIF instanceof CIMProvider) {
                Debug.trace3((String)("The " + string + " is a CIMProvider"));
                this.serviceProviders.add(string);
            }
        } else {
            Debug.trace3((String)("The " + string + " says it is not valid"));
        }
    }

    void UnRegisterProtocolProvider(String string) {
        if (this.mShouldReturnNull) {
            return;
        }
        ProviderProtocolAdapterIF providerProtocolAdapterIF = (ProviderProtocolAdapterIF)this.mAdapters.get(string);
        if (providerProtocolAdapterIF != null) {
            Debug.trace3((String)("Removing protocol adapter:" + string));
            this.mAdapters.remove(string);
            providerProtocolAdapterIF.stop();
        }
    }

    public CIMInstanceProvider getInstanceProvider(String string, CIMClass cIMClass) throws CIMException {
        CIMInstanceProvider cIMInstanceProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            cIMInstanceProvider = null;
            CIMQualifier cIMQualifier = cIMClass.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + cIMClass));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException", (Throwable)classNotFoundException);
                throw new CIMProviderException("NO_INSTANCE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
            }
            if (providerAdapterIF.isInstanceProvider()) {
                try {
                    cIMInstanceProvider = (CIMInstanceProvider)providerAdapterIF.getProvider();
                    if (cIMInstanceProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_INSTANCE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_INSTANCE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isInstanceProvider returned false");
            throw new CIMProviderException("NOT_INSTANCE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
        }
        return cIMInstanceProvider;
    }

    public CIMAssociatorProvider getAssociatorProvider(String string, CIMClass cIMClass) throws CIMException {
        CIMAssociatorProvider cIMAssociatorProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            cIMAssociatorProvider = null;
            CIMQualifier cIMQualifier = cIMClass.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + cIMClass));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NOe_ASSOCIATOR_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
            }
            if (providerAdapterIF.isAssociatorProvider()) {
                try {
                    cIMAssociatorProvider = (CIMAssociatorProvider)providerAdapterIF.getProvider();
                    if (cIMAssociatorProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NOe_ASSOCIATOR_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_ASSOCIATOR_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isAssociatorProvider returned false");
            throw new CIMProviderException("NOT_ASSOCIATOR_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
        }
        return cIMAssociatorProvider;
    }

    public Authorizable getAuthorizableProvider(String string, CIMClass cIMClass) throws CIMException {
        Authorizable authorizable;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            authorizable = null;
            CIMQualifier cIMQualifier = cIMClass.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + cIMClass));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
            }
            if (providerAdapterIF.isAuthorizable()) {
                try {
                    authorizable = (Authorizable)providerAdapterIF.getProvider();
                    if (authorizable == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isAuthorizable returned false");
            throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
        }
        return authorizable;
    }

    public Authorizable getAuthorizableProvider(String string, CIMMethod cIMMethod) throws CIMException {
        Authorizable authorizable;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            authorizable = null;
            CIMQualifier cIMQualifier = cIMMethod.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for Method: " + cIMMethod));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
            }
            if (providerAdapterIF.isAuthorizable()) {
                try {
                    authorizable = (Authorizable)providerAdapterIF.getProvider();
                    if (authorizable == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isAuthorizable returned false");
            throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
        }
        return authorizable;
    }

    public Authorizable getAuthorizableProvider(String string, CIMProperty cIMProperty) throws CIMException {
        Authorizable authorizable;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            authorizable = null;
            CIMQualifier cIMQualifier = cIMProperty.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for Property: " + cIMProperty));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
            }
            if (providerAdapterIF.isAuthorizable()) {
                try {
                    authorizable = (Authorizable)providerAdapterIF.getProvider();
                    if (authorizable == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_AUTHORIZABLE_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isAuthorizable returned false");
            throw new CIMProviderException("NOT_AUTHORIZABLE_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
        }
        return authorizable;
    }

    public PropertyProvider getPropertyProvider(String string, CIMClass cIMClass) throws CIMException {
        PropertyProvider propertyProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            propertyProvider = null;
            CIMQualifier cIMQualifier = cIMClass.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + cIMClass));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_PROPERTY_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
            }
            if (providerAdapterIF.isPropertyProvider()) {
                try {
                    propertyProvider = (PropertyProvider)providerAdapterIF.getProvider();
                    if (propertyProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_PROPERTY_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_PROPERTY_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isPropertyProvider returned false");
            throw new CIMProviderException("NOT_PROPERTY_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
        }
        return propertyProvider;
    }

    public PropertyProvider getPropertyProvider(String string, CIMProperty cIMProperty, CIMClass cIMClass) throws CIMException {
        PropertyProvider propertyProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            propertyProvider = null;
            CIMQualifier cIMQualifier = cIMProperty.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for Property: " + cIMProperty));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_PROPERTY_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
            }
            if (providerAdapterIF.isPropertyProvider()) {
                try {
                    propertyProvider = (PropertyProvider)providerAdapterIF.getProvider();
                    if (propertyProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_PROPERTY_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_PROPERTY_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isPropertyProvider returned false");
            throw new CIMProviderException("NOT_PROPERTY_PROVIDER", (Object)cIMProperty.getName(), (Object)string2);
        }
        return propertyProvider;
    }

    public CIMMethodProvider getMethodProvider(String string, CIMClass cIMClass) throws CIMException {
        CIMMethodProvider cIMMethodProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            cIMMethodProvider = null;
            CIMQualifier cIMQualifier = cIMClass.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + cIMClass));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
            }
            if (providerAdapterIF.isMethodProvider()) {
                try {
                    cIMMethodProvider = (CIMMethodProvider)providerAdapterIF.getProvider();
                    if (cIMMethodProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isMethodProvider returned false");
            throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
        }
        return cIMMethodProvider;
    }

    public CIMMethodProvider getMethodProvider(String string, CIMMethod cIMMethod, CIMClass cIMClass) throws CIMException {
        CIMMethodProvider cIMMethodProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            cIMMethodProvider = null;
            CIMQualifier cIMQualifier = cIMMethod.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for Method: " + cIMMethod));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
            }
            if (providerAdapterIF.isMethodProvider()) {
                try {
                    cIMMethodProvider = (CIMMethodProvider)providerAdapterIF.getProvider();
                    if (cIMMethodProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_METHOD_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isMethodProvider returned false");
            throw new CIMProviderException("NOT_METHOD_PROVIDER", (Object)cIMMethod.getName(), (Object)string2);
        }
        return cIMMethodProvider;
    }

    public EventProvider getEventProvider(String string, CIMClass cIMClass) throws CIMException {
        EventProvider eventProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            eventProvider = null;
            CIMQualifier cIMQualifier = cIMClass.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + cIMClass));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_EVENT_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
            }
            if (providerAdapterIF.isEventProvider()) {
                try {
                    eventProvider = (EventProvider)providerAdapterIF.getProvider();
                    if (eventProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_EVENT_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_EVENT_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isEventProvider returned false");
            throw new CIMProviderException("NOT_EVENT_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
        }
        return eventProvider;
    }

    public CIMIndicationProvider getCIMIndicationProvider(String string, CIMClass cIMClass) throws CIMException {
        CIMIndicationProvider cIMIndicationProvider;
        block8: {
            if (this.mShouldReturnNull) {
                return null;
            }
            cIMIndicationProvider = null;
            CIMQualifier cIMQualifier = cIMClass.getQualifier("provider");
            if (cIMQualifier == null) {
                Debug.trace3((String)("No 'provider' qualifier found for class: " + cIMClass));
                return null;
            }
            String string2 = this.getProviderString(cIMQualifier);
            ProviderAdapterIF providerAdapterIF = null;
            try {
                providerAdapterIF = this.getProviderAdapter(string, string2, cIMClass);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Debug.trace3((String)"getProviderAdapter threw ClassNotFoundException");
                throw new CIMProviderException("NO_INDICATION_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
            }
            if (providerAdapterIF.isCIMIndicationProvider()) {
                try {
                    cIMIndicationProvider = (CIMIndicationProvider)providerAdapterIF.getProvider();
                    if (cIMIndicationProvider == null) {
                        Debug.trace3((String)"getProvider returned NULL");
                        throw new CIMProviderException("NO_INDICATION_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                    }
                    break block8;
                }
                catch (ClassCastException classCastException) {
                    Debug.trace3((String)"Class Cast Exception", (Throwable)classCastException);
                    throw new CIMProviderException("NOT_INDICATION_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
                }
            }
            Debug.trace3((String)"isCIMIndicationProvider returned false");
            throw new CIMProviderException("NOT_INDICATION_PROVIDER", (Object)cIMClass.getName(), (Object)string2);
        }
        return cIMIndicationProvider;
    }

    private ProviderAdapterIF getProviderAdapter(String string, String string2, CIMClass cIMClass) throws CIMClassException, CIMException, ClassNotFoundException {
        Object object;
        String string3 = this.getProviderName(string2);
        Debug.trace3((String)("Need to get provider named " + string3));
        Object object2 = this.mProviders.get(string3);
        ProviderProtocolAdapterIF providerProtocolAdapterIF = null;
        try {
            object = this.getProtocol(string2);
            Debug.trace3((String)("Need to get provider protocol adapter " + (String)object));
            providerProtocolAdapterIF = (ProviderProtocolAdapterIF)this.mAdapters.get(object);
            if (providerProtocolAdapterIF == null) {
                Debug.trace3((String)("Did not find provider protocol adapter for: " + (String)object));
                throw new CIMProviderException("UNKNOWN_PROVIDER_ADAPTER", object);
            }
        }
        catch (Exception exception) {
            throw new CIMClassException(exception.toString());
        }
        if (object2 == null) {
            Debug.trace3((String)"Loading provider from adapter");
            object2 = providerProtocolAdapterIF.loadProvider(string, string3, this.getProviderParams(string2), cIMClass);
            this.mProviders.put(string3, object2);
        }
        Debug.trace3((String)"Getting provider adapter interface");
        object = providerProtocolAdapterIF.getProviderAdapter(object2);
        Debug.trace3((String)("Got adapter interface " + object));
        return object;
    }

    private String getProtocol(String string) {
        int n = string.indexOf(58);
        Debug.trace3((String)"getting protocol");
        if (n < 0) {
            Debug.trace3((String)"No provider qualifier, defaulting to 'sunjava'");
            return "sunjava";
        }
        String string2 = string.substring(0, n);
        Debug.trace3((String)("Protocol: " + string2));
        return string2;
    }

    private String getProviderName(String string) throws CIMException {
        int n;
        int n2 = string.indexOf(58);
        int n3 = string.length();
        if (n2 < 0) {
            return string;
        }
        if (n2 == n3 - 1) {
            Debug.trace3((String)("Invalid provider qualifier: " + string));
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", (Object)string);
        }
        if ((n = string.indexOf(58, ++n2)) < 0) {
            n = n3;
        }
        String string2 = string.substring(n2, n);
        Debug.trace3((String)("Provider: " + string2));
        return string2;
    }

    private String[] getProviderParams(String string) {
        int n;
        int n2 = string.indexOf(58);
        int n3 = string.length();
        if (n2 < 0 || n2 == n3 - 1) {
            return new String[0];
        }
        if ((n = string.indexOf(58, ++n2)) < 0) {
            return new String[0];
        }
        n2 = 0;
        String string2 = string.substring(++n);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    private String getProviderString(CIMQualifier cIMQualifier) throws CIMClassException, CIMException {
        if (cIMQualifier == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)"Invalid qualifier, can not be null!");
        }
        String string = (String)cIMQualifier.getValue().getValue();
        if (cIMQualifier == null) {
            throw new CIMClassException("CIM_ERR_NOT_FOUND", (Object)"Invalid provider qualifier, no value found!");
        }
        return string;
    }

    void startAdapters() throws CIMException {
        CIMInstance cIMInstance = null;
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(PPACIMCLASS);
            cIMObjectPath.setNameSpace("\\root\\cimv2");
            CIMInstance[] cIMInstanceArray = this.adapterProvider.enumerateInstances(cIMObjectPath, false, true, true, null, null);
            int n = 0;
            while (n < cIMInstanceArray.length) {
                cIMInstance = cIMInstanceArray[n];
                this.handleAdapterInstance(cIMInstance);
                cIMInstance = null;
                ++n;
            }
        }
        catch (Exception exception) {
            Debug.trace1((String)("Provider registration failed: " + (cIMInstance == null ? "no provider" : cIMInstance.getName())), (Throwable)exception);
        }
    }

    private void handleAdapterInstance(CIMInstance cIMInstance) throws CIMException {
        Debug.trace3((String)("Handling provider protocol " + cIMInstance));
        try {
            String string;
            Object object;
            CIMProperty cIMProperty = cIMInstance.getProperty(CLASSPATH);
            CIMValue cIMValue = cIMProperty.getValue();
            String[] stringArray = new String[]{};
            if (cIMValue != null && !cIMValue.isNullValue() && cIMValue.getType().getType() == 22) {
                object = (Vector)cIMValue.getValue();
                stringArray = ((Vector)object).toArray(new String[((Vector)object).size()]);
            }
            object = new DynClassLoader(stringArray, this.getClass().getClassLoader());
            CIMProperty cIMProperty2 = cIMInstance.getProperty(IMPLCLASS);
            CIMValue cIMValue2 = cIMProperty2.getValue();
            String string2 = (String)cIMValue2.getValue();
            Class clazz = object.loadClass(string2);
            String string3 = "";
            try {
                string3 = (String)cIMInstance.getProperty("StartMode").getValue().getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = (String)cIMInstance.getProperty(PROTOCOLTYPE).getValue().getValue();
            }
            catch (NullPointerException nullPointerException) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)PROTOCOLTYPE);
            }
            if (string.trim().length() == 0) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)PROTOCOLTYPE);
            }
            if (string.equals("internal")) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)"internal");
            }
            ProviderProtocolAdapterIF providerProtocolAdapterIF = (ProviderProtocolAdapterIF)clazz.newInstance();
            boolean bl = false;
            if (string3.equalsIgnoreCase("Automatic")) {
                bl = true;
            }
            this.RegisterProtocolProvider(string, providerProtocolAdapterIF, bl);
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
        catch (Exception exception) {
            Debug.trace2((String)"Adapter exception", (Throwable)exception);
            throw new CIMException("CIM_ERR_FAILED", (Object)exception.toString());
        }
    }

    private static class AdapterAssocProvider
    extends OneToManyAssocProvider {
        private static final CIMObjectPath PPA_CLASS_OP = new CIMObjectPath("WBEMServices_ObjectManagerProviderProtocolAdapter", "\\root\\cimv2");

        private AdapterAssocProvider() {
        }

        protected String getOneRole(CIMObjectPath cIMObjectPath) {
            return "Antecedent";
        }

        protected String getManyRole(CIMObjectPath cIMObjectPath) {
            return "Dependent";
        }

        protected CIMObjectPath getManyClass(CIMObjectPath cIMObjectPath) {
            return PPA_CLASS_OP;
        }

        protected CIMObjectPath getOneClass(CIMObjectPath cIMObjectPath) {
            return CIMOMProvider.CLASSOP;
        }
    }

    private class AdapterProvider
    implements CIMInstanceProvider,
    CIMMethodProvider {
        CIMInstanceProvider internalProvider;

        public AdapterProvider() {
            this.internalProvider = ProviderAdapterFactory.this.mCimom.getInternalCIMInstanceProvider();
        }

        public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
            return this.internalProvider.enumerateInstanceNames(cIMObjectPath, cIMClass);
        }

        public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
            return this.internalProvider.enumerateInstances(cIMObjectPath, bl, bl2, bl3, stringArray, cIMClass);
        }

        public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
            return this.internalProvider.getInstance(cIMObjectPath, bl, bl2, bl3, stringArray, cIMClass);
        }

        public synchronized CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
            CIMObjectPath cIMObjectPath2 = this.internalProvider.createInstance(cIMObjectPath, cIMInstance);
            try {
                ProviderAdapterFactory.this.handleAdapterInstance(cIMInstance);
            }
            catch (CIMException cIMException) {
                CIMObjectPath cIMObjectPath3 = new CIMObjectPath();
                cIMObjectPath3.setNameSpace(cIMObjectPath.getNameSpace());
                cIMObjectPath3.setObjectName(cIMObjectPath.getObjectName());
                cIMObjectPath3.setKeys(cIMInstance.getKeyValuePairs());
                this.internalProvider.deleteInstance(cIMObjectPath3);
                throw cIMException;
            }
            return cIMObjectPath2;
        }

        public synchronized void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, boolean bl, String[] stringArray) throws CIMException {
            throw new CIMException("CIM_ERR_NOT_SUPPORTED");
        }

        public synchronized void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
            String string;
            CIMInstance cIMInstance = this.getInstance(cIMObjectPath, false, false, false, null, null);
            try {
                string = (String)cIMInstance.getProperty(ProviderAdapterFactory.PROTOCOLTYPE).getValue().getValue();
            }
            catch (NullPointerException nullPointerException) {
                throw new CIMPropertyException("CIM_ERR_INVALID_PARAMETER", (Object)ProviderAdapterFactory.PROTOCOLTYPE);
            }
            ProviderAdapterFactory.this.UnRegisterProtocolProvider(string);
            this.internalProvider.deleteInstance(cIMObjectPath);
        }

        public void initialize(CIMOMHandle cIMOMHandle) {
        }

        public void cleanup() {
        }

        public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
            return this.internalProvider.execQuery(cIMObjectPath, string, string2, cIMClass);
        }

        public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, CIMArgument[] cIMArgumentArray, CIMArgument[] cIMArgumentArray2) throws CIMException {
            String string2;
            CIMInstance cIMInstance = this.getInstance(cIMObjectPath, false, false, false, null, null);
            try {
                string2 = (String)cIMInstance.getProperty(ProviderAdapterFactory.PROTOCOLTYPE).getValue().getValue();
            }
            catch (NullPointerException nullPointerException) {
                return new CIMValue((Object)new Integer(2));
            }
            ProviderProtocolAdapterIF providerProtocolAdapterIF = (ProviderProtocolAdapterIF)ProviderAdapterFactory.this.mAdapters.get(string2);
            if (providerProtocolAdapterIF == null) {
                return new CIMValue((Object)new Integer(3));
            }
            if (string.equalsIgnoreCase(ProviderAdapterFactory.STARTSERVICE)) {
                providerProtocolAdapterIF.start();
            } else {
                providerProtocolAdapterIF.stop();
            }
            return new CIMValue((Object)new Integer(0));
        }
    }
}

