  global EditorWindows
  set n [Unique]
  set win .editor$n
  set EditorWindows [linsert $EditorWindows 0 $win] 

  global Skip.$win
  set Skip.$win 0
  global AutoGoto.$win
  set AutoGoto.$win 0
  global Controls.$win
  set Controls.$win 1
  global Overlay.$win
  set Overlay.$win 0

  LinkWindow $head.editor $win
  LinkWindow $win.head $head

  catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  bind $win <Visibility> {[WindowLink %W.view] Visible [string compare %s FullyObscured]}
  bind $win <Map> {[WindowLink %W.view] Visible 1}
  bind $win <Unmap> {[WindowLink %W.view] Visible 0}
  # $head.editor points to most recently created or entered editor
  bind $win <Enter> "LinkWindow $head.editor $win"

  global CityName
  wm title $win "SimCity Editor"
  wm iconname $win $CityName
  wm group $win $head
  wm geometry $win 550x535+440+5
  wm positionfrom $win user
  wm withdraw $win
  wm maxsize $win 2000 2000
  wm minsize $win 32 32
  wm protocol $win delete "DeleteWindow editor EditorWindows"

  frame $win.topframe\
    -borderwidth 0

  frame $win.topframe.controls\
    -borderwidth 2\
    -relief raised

  menubutton $win.topframe.controls.update\
    -menu $win.topframe.controls.update.m\
    -text {Display}\
    -font [Font $win Medium]\
    -variable $win.postedMenu\
    -borderwidth 2\
    -relief flat
  tk_bindForTraversal $win.topframe.controls.update
  bind $win.topframe.controls.update <F10> {tk_firstMenu %W} 
  bind $win.topframe.controls.update <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus $win $win.topframe.controls.update

  menu $win.topframe.controls.update.m\
    -font [Font $win Medium]
  tk_bindForTraversal $win.topframe.controls.update.m
  bind $win.topframe.controls.update.m <F10> {tk_firstMenu %W} 
  bind $win.topframe.controls.update.m <Mod2-Key> {tk_traverseToMenu %W %A} 
    $win.topframe.controls.update.m add radiobutton\
      -label {Always}\
      -variable Skip.$win\
      -value 0\
      -command "SetEditorSkip $win 0"
    $win.topframe.controls.update.m add radiobutton\
      -label {Often}\
      -variable Skip.$win\
      -value 1\
      -command "SetEditorSkip $win 1"
    $win.topframe.controls.update.m add radiobutton\
      -label {Sometimes}\
      -variable Skip.$win\
      -value 2\
      -command "SetEditorSkip $win 4"
    $win.topframe.controls.update.m add radiobutton\
      -label {Seldom}\
      -variable Skip.$win\
      -value 3\
      -command "SetEditorSkip $win 16"
    $win.topframe.controls.update.m add radiobutton\
      -label {Rarely}\
      -variable Skip.$win\
      -value 4\
      -command "SetEditorSkip $win 64"

  menubutton $win.topframe.controls.options\
    -menu $win.topframe.controls.options.m\
    -text {Options}\
    -font [Font $win Medium]\
    -variable $win.postedMenu\
    -borderwidth 2\
    -relief flat
  tk_bindForTraversal $win.topframe.controls.options
  bind $win.topframe.controls.options <F10> {tk_firstMenu %W} 
  bind $win.topframe.controls.options <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus $win $win.topframe.controls.options

  menu $win.topframe.controls.options.m\
    -font [Font $win Medium]
  tk_bindForTraversal $win.topframe.controls.options.m
  bind $win.topframe.controls.options.m <F10> {tk_firstMenu %W} 
  bind $win.topframe.controls.options.m <Mod2-Key> {tk_traverseToMenu %W %A} 
  $win.topframe.controls.options.m add checkbutton\
    -label {Auto Goto}\
    -variable AutoGoto.$win\
    -command "SetEditorAutoGoto $win \$\{AutoGoto.$win\}"
  $win.topframe.controls.options.m add checkbutton\
    -label {Pallet Panel}\
    -variable Controls.$win\
    -command "SetEditorControls $win \$\{Controls.$win\}"
  $win.topframe.controls.options.m add checkbutton\
    -label {Chalk Overlay}\
    -variable Overlay.$win\
    -command "SetEditorOverlay $win \$\{Overlay.$win\}"

  pack append $win.topframe.controls\
    $win.topframe.controls.update {left frame ne}\
    $win.topframe.controls.options {left frame ne}

  label $win.topframe.messagelabel\
    -borderwidth 2\
    -relief raised\
    -font [Font $win Large]\
    -text {}\
    -width 23
  LinkWindow $win.message $win.topframe.messagelabel

  pack append $win.topframe\
    $win.topframe.controls	{left frame ne} \
    $win.topframe.messagelabel	{left frame ne expand fill} 

  frame $win.centerframe\
    -cursor hand2\
    -borderwidth 2\
    -relief sunken

  editorview $win.centerframe.view\
    -font [Font $win Big]
  LinkWindow $win.view $win.centerframe.view
  LinkWindow $win.centerframe.view.top $win

  BindEditorButtons $win.centerframe.view

  bind $win.centerframe.view <Any-Enter> {focus %W}

  set entry [WindowLink $head.entry]
  bind $win.centerframe.view <Any-KeyPress> "
      if {\"%A\" != \"\"} {
	  $entry insert cursor %A
	  tk_entrySeeCaret $entry
      }
  "

  bind $win.centerframe.view <Delete> "tk_entryDelPress $entry"
  bind $win.centerframe.view <BackSpace> "tk_entryDelPress $entry"
  bind $win.centerframe.view <Control-h> "tk_entryDelPress $entry"
  bind $win.centerframe.view <Control-d> "tk_textCutPress $entry"
  bind $win.centerframe.view <Control-u> "tk_entryDelLine $entry"
  bind $win.centerframe.view <Control-v> "tk_entryCopyPress $entry"
  bind $win.centerframe.view <Control-w> "tk_entryBackword $entry; tk_entrySeeCaret $entry"
  bind $win.centerframe.view <Return> "DoEnterMessage $entry $entry.value"
  bind $win.centerframe.view <Escape> "DoEvalMessage $entry $entry.value"

  bind $win.centerframe.view <Up> "%W PanBy 0 16 ; %W TweakCursor"
  bind $win.centerframe.view <Down> "%W PanBy 0 -16 ; %W TweakCursor"
  bind $win.centerframe.view <Left> "%W PanBy 16 0 ; %W TweakCursor"
  bind $win.centerframe.view <Right> "%W PanBy -16 0 ; %W TweakCursor"
  bind $win.centerframe.view <Tab> "EditorToolDown none %W %x %y ; EditorToolUp %W %x %y"

  bind $win.centerframe.view <Meta-KeyPress> {EditorKeyDown %W %K}
  bind $win.centerframe.view <Meta-KeyRelease> {EditorKeyUp %W %K}
  bind $win.centerframe.view <Shift-Meta-KeyPress> {EditorKeyDown %W %K}
  bind $win.centerframe.view <Shift-Meta-KeyRelease> {EditorKeyUp %W %K}

  pack append $win.centerframe\
    $win.centerframe.view {top frame center fill expand}

  frame $win.leftframe\
    -borderwidth 2\
    -relief raised\
    -geometry 130x10

  frame $win.leftframe.tools\
    -borderwidth 0\
    -relief flat

  label $win.leftframe.tools.costlabel1\
    -relief flat\
    -font [Font $win Medium]\
    -text {}
  LinkWindow $win.cost1 $win.leftframe.tools.costlabel1
  LinkWindow $win.centerframe.view.cost1 $win.leftframe.tools.costlabel1

  label $win.leftframe.tools.costlabel2\
    -relief flat\
    -font [Font $win Medium]\
    -text {}
  LinkWindow $win.cost2 $win.leftframe.tools.costlabel2
  LinkWindow $win.centerframe.view.cost2 $win.leftframe.tools.costlabel2

  canvas $win.leftframe.tools.spacer\
    -width 132 -height 4

  button $win.leftframe.tools.palletres\
    -bitmap "@images/icres.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 0"

  button $win.leftframe.tools.palletcom\
    -bitmap "@images/iccom.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 1"

  button $win.leftframe.tools.palletind\
    -bitmap "@images/icind.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 2"

  button $win.leftframe.tools.palletfire\
    -bitmap "@images/icfire.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 3"

  button $win.leftframe.tools.palletquery\
    -bitmap "@images/icqry.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 4"

  button $win.leftframe.tools.palletpolice\
    -bitmap "@images/icpol.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 5"

  button $win.leftframe.tools.palletwire\
    -bitmap "@images/icwire.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 6"

  button $win.leftframe.tools.palletbulldozer\
    -bitmap "@images/icdozr.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 7"

  button $win.leftframe.tools.palletrail\
    -bitmap "@images/icrail.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 8"

  button $win.leftframe.tools.palletroad\
    -bitmap "@images/icroad.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 9"

  button $win.leftframe.tools.palletchalk\
    -bitmap "@images/icchlk.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 10"

  button $win.leftframe.tools.palleteraser\
    -bitmap "@images/icersr.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 11"

  button $win.leftframe.tools.palletstadium\
    -bitmap "@images/icstad.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 12"

  button $win.leftframe.tools.palletpark\
    -bitmap "@images/icpark.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 13"

  button $win.leftframe.tools.palletseaport\
    -bitmap "@images/icseap.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 14"

  button $win.leftframe.tools.palletcoal\
    -bitmap "@images/iccoal.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 15"

  button $win.leftframe.tools.palletnuclear\
    -bitmap "@images/icnuc.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 16"

  button $win.leftframe.tools.palletairport\
    -bitmap "@images/icairp.xpm"\
    -borderwidth 1 -relief flat -padx 0 -pady 0 -text {} -cursor hand2\
    -command "EditorPallet $win 17"

  pack append $win.leftframe.tools\
    $win.leftframe.tools.costlabel1 {top frame center fillx}\
    $win.leftframe.tools.costlabel2 {top frame center fillx}\
    $win.leftframe.tools.spacer     {top frame center fillx}

  place $win.leftframe.tools.palletres -x 9 -y 48
  place $win.leftframe.tools.palletcom -x 47 -y 48
  place $win.leftframe.tools.palletind -x 85 -y 48
  place $win.leftframe.tools.palletfire -x 9 -y 102
  place $win.leftframe.tools.palletquery -x 47 -y 102
  place $win.leftframe.tools.palletpolice -x 85 -y 102
  place $win.leftframe.tools.palletwire -x 28 -y 140
  place $win.leftframe.tools.palletbulldozer -x 66 -y 140
  place $win.leftframe.tools.palletrail -x 6 -y 178
  place $win.leftframe.tools.palletroad -x 66 -y 178
  place $win.leftframe.tools.palletchalk -x 28 -y 206
  place $win.leftframe.tools.palleteraser -x 66 -y 206
  place $win.leftframe.tools.palletstadium -x 1 -y 244
  place $win.leftframe.tools.palletpark -x 47 -y 244
  place $win.leftframe.tools.palletseaport -x 85 -y 244
  place $win.leftframe.tools.palletcoal -x 1 -y 290
  place $win.leftframe.tools.palletnuclear -x 85 -y 290
  place $win.leftframe.tools.palletairport -x 35 -y 336

  pack append $win.leftframe\
    $win.leftframe.tools	{top frame center expand fill}

  pack append $win\
    $win.topframe	{top frame center fillx} \
    $win.centerframe	{right frame center expand fill} \
    $win.leftframe	{left frame center filly} 

  global ShapePies

  piemenu $win.toolpie\
      -title Tool\
      -font [Font $win Medium]\
      -fixedradius 26\
      -shaped $ShapePies\
      -preview "UIMakeSoundOn $head fancy Woosh {-volume 40}"
    $win.toolpie add command\
      -label Road -bitmap "@images/icroadhi.xpm"\
      -xoffset -4\
      -command "EditorSetTool $win 9"
    $win.toolpie add command\
      -label Bulldozer -bitmap "@images/icdozrhi.xpm"\
      -xoffset 5 -yoffset 17\
      -command "EditorSetTool $win 7"
    $win.toolpie add piemenu\
      -font [Font $win Medium]\
      -label Zone -piemenu $win.zonepie 
    $win.toolpie add command\
      -label Wire -bitmap "@images/icwirehi.xpm"\
      -xoffset -4 -yoffset 17\
      -command "EditorSetTool $win 6"
    $win.toolpie add command\
      -label Rail -bitmap "@images/icrailhi.xpm"\
      -xoffset 4\
      -command "EditorSetTool $win 8"
    $win.toolpie add command\
      -label Chalk -bitmap "@images/icchlkhi.xpm"\
      -xoffset -4 -yoffset -17\
      -command "EditorSetTool $win 10"
    $win.toolpie add piemenu\
      -font [Font $win Medium]\
      -label Build -piemenu $win.buildpie
    $win.toolpie add command\
      -label Eraser -bitmap "@images/icersrhi.xpm"\
      -xoffset 4 -yoffset -17\
      -command "EditorSetTool $win 11"

  piemenu $win.zonepie\
      -title Zone\
      -font [Font $win Medium]\
      -shaped $ShapePies\
      -initialangle 270 -fixedradius 20
    $win.zonepie add command\
      -label Query -bitmap "@images/icqryhi.xpm"\
      -yoffset 5\
      -command "EditorSetTool $win 4"
    $win.zonepie add command\
      -label Police -bitmap "@images/icpolhi.xpm"\
      -xoffset 4 -yoffset -10\
      -command "EditorSetTool $win 5"
    $win.zonepie add command\
      -label Ind -bitmap "@images/icindhi.xpm"\
      -xoffset 4 -yoffset 25\
      -command "EditorSetTool $win 2"
    $win.zonepie add command\
      -label Com -bitmap "@images/iccomhi.xpm"\
      -yoffset -5\
      -command "EditorSetTool $win 1"
    $win.zonepie add command\
      -label Res -bitmap "@images/icreshi.xpm"\
      -xoffset -4 -yoffset 25\
      -command "EditorSetTool $win 0"
    $win.zonepie add command\
      -label Fire -bitmap "@images/icfirehi.xpm"\
      -xoffset -4 -yoffset -10\
      -command "EditorSetTool $win 3"

  piemenu $win.buildpie\
      -title Build\
      -font [Font $win Medium]\
      -shaped $ShapePies\
      -initialangle 270 -fixedradius 25
    $win.buildpie add command\
      -label Airport -bitmap "@images/icairphi.xpm"\
      -yoffset 7\
      -command "EditorSetTool $win 17"
    $win.buildpie add command\
      -label Nuclear -bitmap "@images/icnuchi.xpm"\
      -xoffset 11 -yoffset -10\
      -command "EditorSetTool $win 16"
    $win.buildpie add command\
      -label Seaport -bitmap "@images/icseaphi.xpm"\
      -xoffset 0 -yoffset 14\
      -command "EditorSetTool $win 14"
    $win.buildpie add command\
      -label Park -bitmap "@images/icparkhi.xpm"\
      -yoffset -5\
      -command "EditorSetTool $win 13"
    $win.buildpie add command\
      -label Stadium -bitmap "@images/icstadhi.xpm"\
      -xoffset 0 -yoffset 14\
      -command "EditorSetTool $win 12"
    $win.buildpie add command\
      -label Coal -bitmap "@images/iccoalhi.xpm"\
      -xoffset -11 -yoffset -10\
      -command "EditorSetTool $win 15"

  SetEditorAutoGoto $win 0
  SetEditorControls $win 1
  SetEditorOverlay $win 1

  InitEditor $win

  global CityName
  UISetCityName $CityName

  update idletasks
  return $win
