  global KeyWindows
  set n [Unique]
  set win .key$n
  set KeyWindows [linsert $KeyWindows 0 $win]

  LinkWindow $head.key $win
  LinkWindow $win.head $head

  catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  wm title $win {SimCity Key}
  wm iconname $win {SimCity Key}
  wm geometry $win 400x475+5+5
  wm positionfrom $win user
  wm sizefrom $win user
  wm maxsize $win 1000 1000
  wm minsize $win 100 100
  wm protocol $win delete "DeleteWindow key KeyWindows"


  frame $win.top \
    -relief raised \
    -borderwidth 2
  LinkWindow $win.background $win.top

  label $win.top.title \
    -borderwidth 4 \
    -relief raised \
    -font [Font $win Large] \
    -background [Color $win #00bf00 #ffffff] \
    -text "Get SimCity License Key"
  LinkWindow $win.title $win.top.title

  text $win.top.text \
    -borderwidth 4 \
    -relief flat \
    -wrap word \
    -state normal \
    -height 10 \
    -font [Font $win Large]
  LinkWindow $win.text $win.top.text
  $win.top.text delete 0.0 end
  $win.top.text insert end "\
To get a key to SimCity, contact DUX Software:

    Phone:	+1 (800) 543-4999
		+1 (415) 967-1500
    FAX:		+1 (415) 967-5528
    EMail:	simcity@dux.com
    Mail:		DUX Software       
		4906 El Camino Real
		Suite 1            
		Los Altos, CA 94022
"

  $win.top.text configure -state disabled

  text $win.top.intro \
    -borderwidth 4 \
    -relief flat \
    -wrap word \
    -state normal \
    -height 8 \
    -font [Font $win Medium]
  LinkWindow $win.intro $win.top.intro
  $win.top.intro delete 0.0 end
  $win.top.intro insert end {\
SimCity runs in demo mode if you don't have a license key:
The city melts after 5 minutes, or if you try to save it.
A "Node Locked" license only runs on a particular computer.
A "Floating" license runs on any computer on the network.
A "Single Player" license lets you play on one X11 display.
A "Multi Player" license lets several people play, \
by opening windows on other X11 displays!}

  $win.top.intro configure -state disabled

  frame $win.top.controls \
    -relief flat \
    -borderwidth 0

  frame $win.top.controls.left \
    -relief flat \
    -borderwidth 4

  label $win.top.controls.left.current \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "Current License:"

  label $win.top.controls.left.type \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "Get Key Type:"

  label $win.top.controls.left.code \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "Your Code:"

  label $win.top.controls.left.key \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "Enter Key:"

  pack append $win.top.controls.left \
    $win.top.controls.left.current	{top frame e expand pady 4} \
    $win.top.controls.left.type		{top frame e expand pady 4} \
    $win.top.controls.left.code		{top frame e expand pady 4} \
    $win.top.controls.left.key		{top frame e expand pady 4}

  frame $win.top.controls.right \
    -relief flat \
    -borderwidth 4

  label $win.top.controls.right.current \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "None"
  LinkWindow $win.current $win.top.controls.right.current

  menubutton $win.top.controls.right.type \
    -relief raised \
    -borderwidth 2 \
    -menu $win.top.controls.right.type.m \
    -font [Font $win Large] \
    -text "Node Locked"
  tk_bindForTraversal $win.top.controls.right.type
  bind $win.top.controls.right.type <F10> {tk_firstMenu %W} 
  bind $win.top.controls.right.type <Mod2-Key> {tk_traverseToMenu %W %A} 
  LinkWindow $win.type $win.top.controls.right.type

  tk_menus $win $win.top.controls.right.type

  menu $win.top.controls.right.type.m\
    -font [Font $win Large]
  tk_bindForTraversal $win.top.controls.right.type.m
  bind $win.top.controls.right.type.m <F10> {tk_firstMenu %W} 
  bind $win.top.controls.right.type.m <Mod2-Key> {tk_traverseToMenu %W %A} 
    $win.top.controls.right.type.m add radiobutton\
      -variable KindOfLicense \
      -value 0 \
      -label {Node Locked, Single Player}\
      -command "SetKindOfLicense 0"
    $win.top.controls.right.type.m add radiobutton\
      -variable KindOfLicense \
      -value 1 \
      -label {Node Locked, Multi Player}\
      -command "SetKindOfLicense 1"
    $win.top.controls.right.type.m add radiobutton\
      -variable KindOfLicense \
      -value 2 \
      -label {Floating, Single Player}\
      -command "SetKindOfLicense 2"
    $win.top.controls.right.type.m add radiobutton\
      -variable KindOfLicense \
      -value 3 \
      -label {Floating, Multi Player}\
      -command "SetKindOfLicense 3"

  label $win.top.controls.right.code \
    -borderwidth 0 \
    -relief flat \
    -font [Font $win Large] \
    -text "xyzzy"
  LinkWindow $win.code $win.top.controls.right.code

  entry $win.top.controls.right.key \
    -relief sunken \
    -font [Font $win Large] \
    -text ""
  bind $win.top.controls.right.key <Return> "DoInstallKey $win"
  bind $win.top.controls.right.key <Any-Enter> {focus %W}
  LinkWindow $win.key $win.top.controls.right.key

  pack append $win.top.controls.right \
    $win.top.controls.right.current	{top frame w expand pady 4 fillx} \
    $win.top.controls.right.type	{top frame w expand pady 4 fillx} \
    $win.top.controls.right.code	{top frame w expand pady 4 fillx} \
    $win.top.controls.right.key		{top frame w expand pady 4 fillx}

  pack append $win.top.controls \
    $win.top.controls.left		{left frame center fill} \
    $win.top.controls.right		{right frame center expand fill}

  pack append $win.top\
    $win.top.title	{top frame n fillx} \
    $win.top.text	{top frame n expand fill}\
    $win.top.intro	{top frame n expand fill}\
    $win.top.controls	{top frame n fill}

  button $win.dismiss\
    -font [Font $win Large] \
    -text {Dismiss}\
    -command "wm withdraw $win"

  pack append $win\
    $win.top		{top frame center expand fill} \
    $win.dismiss	{bottom frame s fillx} \

  InitKey $win

  update idletasks
  return $win
