  global MapWindows
  set n [Unique]
  set win .map$n
  set MapWindows [linsert $MapWindows 0 $win]

  global MapState.$win
  set MapState.$win 0

  LinkWindow $head.map $win
  LinkWindow $win.head $head

  catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  bind $win <Visibility> {[WindowLink %W.view] Visible [string compare %s FullyObscured]}
  bind $win <Map> {[WindowLink %W.view] Visible 1}
  bind $win <Unmap> {[WindowLink %W.view] Visible 0}

  wm title $win {SimCity Map}
  wm iconname $win {SimCity Map}
  wm group $win $head
  wm geometry $win 364x332+5+250
  wm positionfrom $win user
  wm withdraw $win
  wm maxsize $win 2000 2000
  wm minsize $win 364 332
  wm protocol $win delete "DeleteWindow map MapWindows"

  frame $win.centerframe\
    -borderwidth 2\
    -relief sunken

  mapview $win.centerframe.view\
    -font [Font $win Large]
  $win.centerframe.view size [expr "[sim WorldX] * 3"] [expr "[sim WorldY] * 3"]
  LinkWindow $win.view $win.centerframe.view
  LinkWindow $win.centerframe.view.pallet $win.topframe

  bind $win.centerframe.view <1> {MapPanDown %W %x %y}
  bind $win.centerframe.view <B1-Motion> {MapPanDrag %W %x %y}
  bind $win.centerframe.view <ButtonRelease-1> {MapPanUp %W %x %y}

  bind $win.centerframe.view <2> {MapPanDown %W %x %y}
  bind $win.centerframe.view <B2-Motion> {MapPanDrag %W %x %y}
  bind $win.centerframe.view <ButtonRelease-2> {MapPanUp %W %x %y}


  pack append $win.centerframe\
    $win.centerframe.view {top frame center expand}

  frame $win.topframe\
    -borderwidth 2\
    -relief raised

  menubutton $win.topframe.zones\
    -menu $win.topframe.zones.m\
    -text {Zones}\
    -font [Font $win Medium]\
    -variable $win.postedMenu\
    -borderwidth 2\
    -relief flat
  LinkWindow $win.zones $win.topframe.zones
  tk_bindForTraversal $win.topframe.zones
  bind $win.topframe.zones <F10> {tk_firstMenu %W} 
  bind $win.topframe.zones <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus $win $win.topframe.zones

  menu $win.topframe.zones.m\
    -font [Font $win Medium]
  tk_bindForTraversal $win.topframe.zones.m
  bind $win.topframe.zones.m <F10> {tk_firstMenu %W} 
  bind $win.topframe.zones.m <Mod2-Key> {tk_traverseToMenu %W %A} 
    $win.topframe.zones.m add radiobutton\
      -label {All}\
      -variable MapState.$win\
      -value 0\
      -command "SetMapState $win 0"
    $win.topframe.zones.m add radiobutton\
      -label {Residential}\
      -variable MapState.$win\
      -value 1\
      -command "SetMapState $win 1"
    $win.topframe.zones.m add radiobutton\
      -label {Commercial}\
      -variable MapState.$win\
      -value 2\
      -command "SetMapState $win 2"
    $win.topframe.zones.m add radiobutton\
      -label {Industrial}\
      -variable MapState.$win\
      -value 3\
      -command "SetMapState $win 3"
    $win.topframe.zones.m add radiobutton\
      -label {Transportation}\
      -variable MapState.$win\
      -value 5\
      -command "SetMapState $win 5"

  menubutton $win.topframe.overlays\
    -menu $win.topframe.overlays.m\
    -text {Overlays}\
    -font [Font $win Medium]\
    -variable $win.postedMenu\
    -borderwidth 2\
    -relief flat
  LinkWindow $win.overlays $win.topframe.overlays
  tk_bindForTraversal $win.topframe.overlays
  bind $win.topframe.overlays <F10> {tk_firstMenu %W} 
  bind $win.topframe.overlays <Mod2-Key> {tk_traverseToMenu %W %A} 

  tk_menus $win $win.topframe.overlays

  menu $win.topframe.overlays.m\
    -font [Font $win Medium]
  tk_bindForTraversal $win.topframe.overlays.m
  bind $win.topframe.overlays.m <F10> {tk_firstMenu %W} 
  bind $win.topframe.overlays.m <Mod2-Key> {tk_traverseToMenu %W %A} 
    $win.topframe.overlays.m add radiobutton\
      -label {Population Density}\
      -variable MapState.$win\
      -value 6\
      -command "SetMapState $win 6"
    $win.topframe.overlays.m add radiobutton\
      -label {Rate of Growth}\
      -variable MapState.$win\
      -value 7\
      -command "SetMapState $win 7"
    $win.topframe.overlays.m add radiobutton\
      -label {Land Value}\
      -variable MapState.$win\
      -value 11\
      -command "SetMapState $win 11"
    $win.topframe.overlays.m add radiobutton\
      -label {Crime Rate}\
      -variable MapState.$win\
      -value 10\
      -command "SetMapState $win 10"
    $win.topframe.overlays.m add radiobutton\
      -label {Pollution Density}\
      -variable MapState.$win\
      -value 9\
      -command "SetMapState $win 9"
    $win.topframe.overlays.m add radiobutton\
      -label {Traffic Density}\
      -variable MapState.$win\
      -value 8\
      -command "SetMapState $win 8"
    $win.topframe.overlays.m add radiobutton\
      -label {Power Grid}\
      -variable MapState.$win\
      -value 4\
      -command "SetMapState $win 4"
    $win.topframe.overlays.m add radiobutton\
      -label {Fire Coverage}\
      -variable MapState.$win\
      -value 12\
      -command "SetMapState $win 12"
    $win.topframe.overlays.m add radiobutton\
      -label {Police Coverage}\
      -variable MapState.$win\
      -value 13\
      -command "SetMapState $win 13"

  label $win.topframe.legend\
    -bitmap "@images/legendn.xpm"
  LinkWindow $win.legend $win.topframe.legend

  pack append $win.topframe\
    $win.topframe.zones		{left frame nw} \
    $win.topframe.overlays	{left frame nw} \
    $win.topframe.legend	{right frame ne}

  pack append $win\
    $win.topframe	{top frame center fillx} \
    $win.centerframe	{top frame center fill}

  InitMap $win

  update idletasks
  return $win
