  global PlayerWindows
  set n [Unique]
  set win .player$n
  set PlayerWindows [linsert $PlayerWindows 0 $win]

  LinkWindow $head.player $win
  LinkWindow $win.head $head

  catch "destroy $win"
  toplevel $win -screen $display

  SetHelp $win Window

  wm title $win {SimCity Players}
  wm iconname $win {SimCity Players}
  wm geometry $win 400x250+5+5
  wm positionfrom $win user
  wm sizefrom $win user
  wm maxsize $win 1000 1000
  wm minsize $win 100 100
  wm protocol $win delete "DeleteWindow player PlayerWindows"

  frame $win.top \
    -relief raised \
    -borderwidth 2
  LinkWindow $win.background $win.top

  label $win.top.label \
    -text "X11 Servers of SimCity Players" \
    -font [Font $win Large]

  text $win.top.text \
    -borderwidth 4 \
    -relief flat \
    -wrap word \
    -state normal \
    -height 4 \
    -font [Font $win Medium]
  LinkWindow $win.text $win.top.text
  $win.top.text delete 0.0 end
  $win.top.text insert end {\
SimCity is connected to the X11 servers listed above.
To add another player to the game, enter their display name.
If you don't have a "Multi Player" license, you can only \
add players on your own display.}

  $win.top.text configure -state disabled

  frame $win.top.f \
    -relief flat \
    -borderwidth 2

  label $win.top.f.label \
    -text "Add Player on X11 Display:" \
    -font [Font $win Large]

  entry $win.top.f.display \
    -relief sunken \
    -font [Font $win Large] \
    -text ""
  bind $win.top.f.display <Return> "DoNewPlayer $win"
  bind $win.top.f.display <Any-Enter> {focus %W}
  LinkWindow $win.display $win.top.f.display

  pack append $win.top.f \
    $win.top.f.label	{left frame nw fillx padx 4} \
    $win.top.f.display	{left frame nw expand fillx padx 4}

  frame $win.top.g \
    -relief flat \
    -borderwidth 2

  scrollbar $win.top.g.scroll \
    -borderwidth 2 \
    -command "$win.top.g.list yview"

  listbox $win.top.g.list \
    -relief sunken \
    -borderwidth 2 \
    -font [Font $win Large] \
    -yscroll "$win.top.g.scroll set"
  LinkWindow $win.players $win.top.g.list

  pack append $win.top.g \
    $win.top.g.scroll {left filly frame e} \
    $win.top.g.list {right expand fill frame w}

  pack append $win.top \
    $win.top.label	{top frame center fillx} \
    $win.top.g		{top frame center expand fill} \
    $win.top.text	{top frame center fill} \
    $win.top.f		{top frame center fillx}

  button $win.dismiss\
    -font [Font $win Large]\
    -text {Dismiss}\
    -command "wm withdraw $win"

  pack append $win\
    $win.top		{top frame center expand fill} \
    $win.dismiss	{bottom frame center fillx}

  UpdatePlayers

  update idletasks
  return $win
