#!/bin/sh -x

PATH=/usr/bin:$PATH
PROGNAME=`/bin/basename $0`

if [ -z "$DAHOME" ] ; then
	LOCAL=1
	if [ -f $HOME/.doomarenarc ] ; then
	    DAHOME=`/bin/grep DAHOME $HOME/.doomarenarc | /bin/tail -1 | \
		/bin/awk '{print $3}'`
	fi
	if [ -z "$DAHOME" ] ; then
	    DAHOME=/export/home/europa/sundoom
	fi
	export DAHOME
else
	LOCAL=0
fi

if [ $PROGNAME = "doom" ] && [ ! -f $DAHOME/doom.wad ] ; then
	PROGNAME=doom1
fi

DOOMDIR=$DAHOME
SAVEDIR=$HOME/.${PROGNAME}save

ARGS=
SIZE=-3

while [ $# -gt 0 ] ; do
    case "$1" in
    -audioplay)
	AUDIOCMD=$2
	shift
	/bin/audioplay $AUDIOCMD > /dev/null 2>&1
	;;
    -file)
	WAD=$2
	WADFILE=`basename $2`
	WADDIR=`dirname $2`
	if [ $LOCAL -eq 1 ] ; then
	    if [ `echo $WAD | cut -c1` != "/" ] ; then
		WADDIR=`pwd`/$WADDIR
	    fi
	else
	    if [ -n "$WADDIR" ] ; then
		/bin/mkdir -p $DAHOME/wads/$WADDIR
		/bin/chmod a+w $DAHOME/wads/$WADDIR
	    fi
	    $DAHOME/bin/updatewad $WAD
	    WADDIR=wads/$WADDIR
	fi
	ARGS="$ARGS"
	shift
	;;
    -[1-4])
	SIZE=$1
	;;
    *)
	ARGS="$ARGS $1"
	;;
    esac
    shift
done

ARGS="$SIZE $ARGS"
echo $PROGNAME $ARGS

echo " "
if [ ! -d "$SAVEDIR" ] ; then
	/bin/mkdir $SAVEDIR
	/bin/chmod u+wx $SAVEDIR
fi
cd $SAVEDIR
/bin/rm -f *.wad

relink () {
	/bin/rm -f $2
	if [ `echo $1 | cut -c1` = "/" ] ; then
	    /bin/ln -s $1/$2 $2
	else
	    /bin/ln -s $DOOMDIR/$1/$2 $2
	fi
}

relink bin sndserver
relink . ${PROGNAME}.wad

if [ -n "$WAD" ] ; then
    relink $WADDIR $WADFILE
fi

PATH=.
export PATH
#LD_PRELOAD=$DOOMDIR/lib/libmouse.so
#export LD_PRELOAD

exec $DOOMDIR/sundgadoom $ARGS
